/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.business;

import java.util.List;
import org.apache.inlong.manager.common.event.process.ProcessEventListener;
import org.apache.inlong.manager.common.event.task.TaskEventListener;
import org.apache.inlong.manager.common.model.definition.Element;
import org.apache.inlong.manager.common.model.definition.EndEvent;
import org.apache.inlong.manager.common.model.definition.Process;
import org.apache.inlong.manager.common.model.definition.StartEvent;
import org.apache.inlong.manager.common.model.definition.Task;
import org.apache.inlong.manager.common.model.definition.UserTask;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowApproverFilterContext;
import org.apache.inlong.manager.service.core.WorkflowApproverService;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.business.BusinessAdminApproveForm;
import org.apache.inlong.manager.service.workflow.business.NewBusinessWorkflowForm;
import org.apache.inlong.manager.service.workflow.business.listener.BusinessCancelProcessListener;
import org.apache.inlong.manager.service.workflow.business.listener.BusinessPassTaskListener;
import org.apache.inlong.manager.service.workflow.business.listener.BusinessRejectProcessListener;
import org.apache.inlong.manager.service.workflow.business.listener.StartCreateResourceProcessListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewBusinessWorkflowDefinition
implements WorkflowDefinition {
    @Autowired
    private BusinessPassTaskListener businessPassTaskListener;
    @Autowired
    private BusinessCancelProcessListener businessCancelProcessListener;
    @Autowired
    private BusinessRejectProcessListener approveRejectProcessListener;
    @Autowired
    private StartCreateResourceProcessListener startCreateResourceProcessListener;
    @Autowired
    private WorkflowApproverService workflowApproverService;

    @Override
    public Process defineProcess() {
        Process process = new Process();
        process.setType(this.getProcessName().getDisplayName());
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(NewBusinessWorkflowForm.class);
        process.setVersion(1);
        process.addListener((ProcessEventListener)this.businessCancelProcessListener);
        process.addListener((ProcessEventListener)this.approveRejectProcessListener);
        process.addListener((ProcessEventListener)this.startCreateResourceProcessListener);
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        UserTask adminUserTask = new UserTask();
        adminUserTask.setName("ut_admin");
        adminUserTask.setDisplayName("System Administrator");
        adminUserTask.setFormClass(BusinessAdminApproveForm.class);
        adminUserTask.setApproverAssign(context -> this.getTaskApprovers(adminUserTask.getName()));
        adminUserTask.addListener((TaskEventListener)this.businessPassTaskListener);
        process.addTask((Task)adminUserTask);
        startEvent.addNext((Element)adminUserTask);
        adminUserTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.NEW_BUSINESS_WORKFLOW;
    }

    private List<String> getTaskApprovers(String taskName) {
        String processName = this.getProcessName().name();
        WorkflowApproverFilterContext context = new WorkflowApproverFilterContext();
        return this.workflowApproverService.getApprovers(processName, taskName, context);
    }
}

