/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.business;

import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.common.exceptions.FormValidateException;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.datastream.DataStreamSummaryInfo;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.service.workflow.BaseWorkflowFormType;

public class NewBusinessWorkflowForm
extends BaseWorkflowFormType {
    public static final String FORM_NAME = "NewBusinessWorkflowForm";
    @ApiModelProperty(value="Access business information", required=true)
    private BusinessInfo businessInfo;
    @ApiModelProperty(value="All data stream information under the business, including the storage information")
    private List<DataStreamSummaryInfo> streamInfoList;

    public void validate() throws FormValidateException {
        Preconditions.checkNotNull((Object)this.businessInfo, (String)"business info is empty");
    }

    public String getFormName() {
        return FORM_NAME;
    }

    public String getInlongGroupId() {
        return this.businessInfo.getInlongGroupId();
    }

    public Map<String, Object> showInList() {
        HashMap show = Maps.newHashMap();
        show.put("groupId", this.businessInfo.getInlongGroupId());
        return show;
    }

    public BusinessInfo getBusinessInfo() {
        return this.businessInfo;
    }

    public List<DataStreamSummaryInfo> getStreamInfoList() {
        return this.streamInfoList;
    }

    public void setBusinessInfo(BusinessInfo businessInfo) {
        this.businessInfo = businessInfo;
    }

    public void setStreamInfoList(List<DataStreamSummaryInfo> streamInfoList) {
        this.streamInfoList = streamInfoList;
    }

    @Override
    public String toString() {
        return "NewBusinessWorkflowForm(businessInfo=" + this.getBusinessInfo() + ", streamInfoList=" + this.getStreamInfoList() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewBusinessWorkflowForm)) {
            return false;
        }
        NewBusinessWorkflowForm other = (NewBusinessWorkflowForm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BusinessInfo this$businessInfo = this.getBusinessInfo();
        BusinessInfo other$businessInfo = other.getBusinessInfo();
        if (this$businessInfo == null ? other$businessInfo != null : !this$businessInfo.equals(other$businessInfo)) {
            return false;
        }
        List<DataStreamSummaryInfo> this$streamInfoList = this.getStreamInfoList();
        List<DataStreamSummaryInfo> other$streamInfoList = other.getStreamInfoList();
        return !(this$streamInfoList == null ? other$streamInfoList != null : !((Object)this$streamInfoList).equals(other$streamInfoList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NewBusinessWorkflowForm;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BusinessInfo $businessInfo = this.getBusinessInfo();
        result = result * 59 + ($businessInfo == null ? 43 : $businessInfo.hashCode());
        List<DataStreamSummaryInfo> $streamInfoList = this.getStreamInfoList();
        result = result * 59 + ($streamInfoList == null ? 43 : ((Object)$streamInfoList).hashCode());
        return result;
    }
}

