/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.business.listener;

import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.event.ListenerResult;
import org.apache.inlong.manager.common.event.process.ProcessEvent;
import org.apache.inlong.manager.common.event.process.ProcessEventListener;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.model.WorkflowContext;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.workflow.business.NewBusinessWorkflowForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BusinessCancelProcessListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(BusinessCancelProcessListener.class);
    @Autowired
    private BusinessService businessService;

    public ProcessEvent event() {
        return ProcessEvent.CANCEL;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        NewBusinessWorkflowForm form = (NewBusinessWorkflowForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        String username = context.getApplicant();
        this.businessService.updateStatus(groupId, EntityStatus.BIZ_WAIT_SUBMIT.getCode(), username);
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

