/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.business.listener;

import org.apache.inlong.manager.common.event.ListenerResult;
import org.apache.inlong.manager.common.event.process.ProcessEvent;
import org.apache.inlong.manager.common.event.process.ProcessEventListener;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.model.WorkflowContext;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.apache.inlong.manager.service.workflow.business.BusinessResourceWorkflowForm;
import org.apache.inlong.manager.service.workflow.business.NewBusinessWorkflowForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StartCreateResourceProcessListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(StartCreateResourceProcessListener.class);
    @Autowired
    private BusinessService businessService;
    @Autowired
    private WorkflowService workflowService;

    public ProcessEvent event() {
        return ProcessEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        NewBusinessWorkflowForm workflowForm = (NewBusinessWorkflowForm)context.getProcessForm();
        String groupId = workflowForm.getInlongGroupId();
        BusinessResourceWorkflowForm resourceWorkflowForm = new BusinessResourceWorkflowForm();
        resourceWorkflowForm.setBusinessInfo(this.businessService.get(groupId));
        String username = context.getApplicant();
        this.workflowService.start(ProcessName.CREATE_BUSINESS_RESOURCE, username, resourceWorkflowForm);
        return ListenerResult.success();
    }

    public boolean async() {
        return true;
    }
}

