/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.consumption;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.inlong.manager.common.event.process.ProcessEventListener;
import org.apache.inlong.manager.common.event.task.TaskEventListener;
import org.apache.inlong.manager.common.model.WorkflowContext;
import org.apache.inlong.manager.common.model.definition.Element;
import org.apache.inlong.manager.common.model.definition.EndEvent;
import org.apache.inlong.manager.common.model.definition.Process;
import org.apache.inlong.manager.common.model.definition.ProcessDetailHandler;
import org.apache.inlong.manager.common.model.definition.StartEvent;
import org.apache.inlong.manager.common.model.definition.Task;
import org.apache.inlong.manager.common.model.definition.UserTask;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowApproverFilterContext;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.core.WorkflowApproverService;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.consumption.ConsumptionAdminApproveForm;
import org.apache.inlong.manager.service.workflow.consumption.NewConsumptionProcessDetailHandler;
import org.apache.inlong.manager.service.workflow.consumption.NewConsumptionWorkflowForm;
import org.apache.inlong.manager.service.workflow.consumption.listener.ConsumptionCancelProcessListener;
import org.apache.inlong.manager.service.workflow.consumption.listener.ConsumptionCompleteProcessListener;
import org.apache.inlong.manager.service.workflow.consumption.listener.ConsumptionPassTaskListener;
import org.apache.inlong.manager.service.workflow.consumption.listener.ConsumptionRejectProcessListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewConsumptionWorkflowDefinition
implements WorkflowDefinition {
    public static final String UT_ADMINT_NAME = "ut_admin";
    public static final String UT_BIZ_OWNER_NAME = "ut_biz_owner";
    @Autowired
    private ConsumptionCompleteProcessListener consumptionCompleteProcessListener;
    @Autowired
    private ConsumptionPassTaskListener consumptionPassTaskListener;
    @Autowired
    private ConsumptionRejectProcessListener consumptionRejectProcessListener;
    @Autowired
    private ConsumptionCancelProcessListener consumptionCancelProcessListener;
    @Autowired
    private WorkflowApproverService workflowApproverService;
    @Autowired
    private NewConsumptionProcessDetailHandler newConsumptionProcessDetailHandler;
    @Autowired
    private BusinessService businessService;

    @Override
    public Process defineProcess() {
        Process process = new Process();
        process.setType("Data Consumption Resource Creation");
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(NewConsumptionWorkflowForm.class);
        process.setVersion(1);
        process.setProcessDetailHandler((ProcessDetailHandler)this.newConsumptionProcessDetailHandler);
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        UserTask bizOwnerUserTask = new UserTask();
        bizOwnerUserTask.setName(UT_BIZ_OWNER_NAME);
        bizOwnerUserTask.setDisplayName("Business Approval");
        bizOwnerUserTask.setApproverAssign(this::bizOwnerUserTaskApprover);
        process.addTask((Task)bizOwnerUserTask);
        UserTask adminUserTask = new UserTask();
        adminUserTask.setName(UT_ADMINT_NAME);
        adminUserTask.setDisplayName("System Administrator");
        adminUserTask.setFormClass(ConsumptionAdminApproveForm.class);
        adminUserTask.setApproverAssign(this::adminUserTaskApprover);
        adminUserTask.addListener((TaskEventListener)this.consumptionPassTaskListener);
        process.addTask((Task)adminUserTask);
        startEvent.addNext((Element)bizOwnerUserTask);
        bizOwnerUserTask.addNext((Element)adminUserTask);
        adminUserTask.addNext((Element)endEvent);
        process.addListener((ProcessEventListener)this.consumptionCompleteProcessListener);
        process.addListener((ProcessEventListener)this.consumptionRejectProcessListener);
        process.addListener((ProcessEventListener)this.consumptionCancelProcessListener);
        return process;
    }

    private List<String> adminUserTaskApprover(WorkflowContext context) {
        return this.workflowApproverService.getApprovers(this.getProcessName().name(), UT_ADMINT_NAME, new WorkflowApproverFilterContext());
    }

    private List<String> bizOwnerUserTaskApprover(WorkflowContext context) {
        NewConsumptionWorkflowForm form = (NewConsumptionWorkflowForm)context.getProcessForm();
        BusinessInfo businessInfo = this.businessService.get(form.getConsumptionInfo().getInlongGroupId());
        if (businessInfo == null || businessInfo.getInCharges() == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(businessInfo.getInCharges().split(","));
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.NEW_CONSUMPTION_WORKFLOW;
    }
}

