/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.consumption;

import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import org.apache.inlong.manager.common.exceptions.FormValidateException;
import org.apache.inlong.manager.common.pojo.consumption.ConsumptionInfo;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.service.workflow.BaseWorkflowFormType;

public class NewConsumptionWorkflowForm
extends BaseWorkflowFormType {
    public static final String FORM_NAME = "NewConsumptionWorkflowForm";
    @ApiModelProperty(value="Data consumption information")
    private ConsumptionInfo consumptionInfo;

    public void validate() throws FormValidateException {
        Preconditions.checkNotNull((Object)this.consumptionInfo, (String)"Data consumption information cannot be empty");
    }

    public String getFormName() {
        return FORM_NAME;
    }

    public String getInlongGroupId() {
        return this.consumptionInfo.getConsumerGroupId();
    }

    public Map<String, Object> showInList() {
        HashMap show = Maps.newHashMap();
        if (this.consumptionInfo != null) {
            show.put("groupId", this.consumptionInfo.getInlongGroupId());
        }
        return show;
    }

    public ConsumptionInfo getConsumptionInfo() {
        return this.consumptionInfo;
    }

    public void setConsumptionInfo(ConsumptionInfo consumptionInfo) {
        this.consumptionInfo = consumptionInfo;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewConsumptionWorkflowForm)) {
            return false;
        }
        NewConsumptionWorkflowForm other = (NewConsumptionWorkflowForm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConsumptionInfo this$consumptionInfo = this.getConsumptionInfo();
        ConsumptionInfo other$consumptionInfo = other.getConsumptionInfo();
        return !(this$consumptionInfo == null ? other$consumptionInfo != null : !this$consumptionInfo.equals(other$consumptionInfo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NewConsumptionWorkflowForm;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConsumptionInfo $consumptionInfo = this.getConsumptionInfo();
        result = result * 59 + ($consumptionInfo == null ? 43 : $consumptionInfo.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "NewConsumptionWorkflowForm(consumptionInfo=" + this.getConsumptionInfo() + ")";
    }
}

