/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.consumption.listener;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.inlong.manager.common.beans.ClusterBean;
import org.apache.inlong.manager.common.enums.ConsumptionStatus;
import org.apache.inlong.manager.common.event.ListenerResult;
import org.apache.inlong.manager.common.event.process.ProcessEvent;
import org.apache.inlong.manager.common.event.process.ProcessEventListener;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.model.WorkflowContext;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.pulsar.PulsarTopicBean;
import org.apache.inlong.manager.common.pojo.tubemq.AddTubeConsumeGroupRequest;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.ConsumptionEntity;
import org.apache.inlong.manager.dao.mapper.ConsumptionEntityMapper;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.thirdpart.mq.PulsarOptService;
import org.apache.inlong.manager.service.thirdpart.mq.TubeMqOptService;
import org.apache.inlong.manager.service.thirdpart.mq.util.PulsarUtils;
import org.apache.inlong.manager.service.workflow.consumption.NewConsumptionWorkflowForm;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsumptionCompleteProcessListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(ConsumptionCompleteProcessListener.class);
    @Autowired
    private PulsarOptService pulsarMqOptService;
    @Autowired
    private ClusterBean clusterBean;
    @Autowired
    private BusinessService businessService;
    @Autowired
    private ConsumptionEntityMapper consumptionMapper;
    @Autowired
    private TubeMqOptService tubeMqOptService;

    public ProcessEvent event() {
        return ProcessEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        NewConsumptionWorkflowForm consumptionForm = (NewConsumptionWorkflowForm)context.getProcessForm();
        Integer consumptionId = consumptionForm.getConsumptionInfo().getId();
        ConsumptionEntity entity = this.consumptionMapper.selectByPrimaryKey(consumptionId);
        if (entity == null) {
            throw new WorkflowListenerException("consumption not exits for id=" + consumptionId);
        }
        String middlewareType = entity.getMiddlewareType();
        if ("TUBE".equalsIgnoreCase(middlewareType)) {
            this.createTubeConsumerGroup(entity);
            return ListenerResult.success((String)"Create Tube consumer group successful");
        }
        if (!"PULSAR".equalsIgnoreCase(middlewareType)) {
            throw new WorkflowListenerException("middleware type [" + middlewareType + "] not supported");
        }
        this.createPulsarTopicMessage(entity);
        this.updateConsumerInfo(consumptionId, entity.getConsumerGroupId());
        return ListenerResult.success((String)"create Tube /Pulsar consumer group successful");
    }

    private void updateConsumerInfo(Integer consumptionId, String consumerGroupId) {
        ConsumptionEntity update = new ConsumptionEntity();
        update.setId(consumptionId);
        update.setStatus(Integer.valueOf(ConsumptionStatus.APPROVED.getStatus()));
        update.setConsumerGroupId(consumerGroupId);
        update.setModifyTime(new Date());
        this.consumptionMapper.updateByPrimaryKeySelective(update);
    }

    private void createPulsarTopicMessage(ConsumptionEntity entity) {
        String groupId = entity.getInlongGroupId();
        BusinessInfo businessInfo = this.businessService.get(groupId);
        Preconditions.checkNotNull((Object)businessInfo, (String)("business not found for groupId=" + groupId));
        String mqResourceObj = businessInfo.getMqResourceObj();
        Preconditions.checkNotNull((Object)mqResourceObj, (String)("mq resource cannot empty for groupId=" + groupId));
        try (PulsarAdmin pulsarAdmin = PulsarUtils.getPulsarAdmin(businessInfo, this.clusterBean.getPulsarAdminUrl());){
            PulsarTopicBean topicMessage = new PulsarTopicBean();
            String tenant = this.clusterBean.getDefaultTenant();
            topicMessage.setTenant(tenant);
            topicMessage.setNamespace(mqResourceObj);
            String consumerGroup = entity.getConsumerGroupId();
            List<String> clusters = PulsarUtils.getPulsarClusters(pulsarAdmin);
            List<String> topics = Arrays.asList(entity.getTopic().split(","));
            this.createPulsarSubscription(pulsarAdmin, consumerGroup, topicMessage, clusters, topics, businessInfo);
        }
        catch (Exception e) {
            log.error("create pulsar topic failed", (Throwable)e);
            throw new WorkflowListenerException("failed to create pulsar topic for groupId=" + groupId + ", reason: " + e.getMessage());
        }
    }

    private void createPulsarSubscription(PulsarAdmin globalPulsarAdmin, String subscription, PulsarTopicBean topicBean, List<String> clusters, List<String> topics, BusinessInfo businessInfo) {
        try {
            for (String cluster : clusters) {
                String serviceUrl = PulsarUtils.getServiceUrl(globalPulsarAdmin, cluster);
                PulsarAdmin pulsarAdmin = PulsarUtils.getPulsarAdmin(businessInfo, serviceUrl);
                Throwable throwable = null;
                try {
                    this.pulsarMqOptService.createSubscriptions(pulsarAdmin, subscription, topicBean, topics);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pulsarAdmin == null) continue;
                    if (throwable != null) {
                        try {
                            pulsarAdmin.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pulsarAdmin.close();
                }
            }
        }
        catch (Exception e) {
            log.error("create pulsar consumer group failed", (Throwable)e);
            throw new WorkflowListenerException("failed to create pulsar consumer group");
        }
    }

    private void createTubeConsumerGroup(ConsumptionEntity consumption) {
        AddTubeConsumeGroupRequest addTubeConsumeGroupRequest = new AddTubeConsumeGroupRequest();
        addTubeConsumeGroupRequest.setClusterId(1);
        addTubeConsumeGroupRequest.setCreateUser(consumption.getCreator());
        AddTubeConsumeGroupRequest.GroupNameJsonSetBean bean = new AddTubeConsumeGroupRequest.GroupNameJsonSetBean();
        bean.setTopicName(consumption.getTopic());
        bean.setGroupName(consumption.getConsumerGroupId());
        addTubeConsumeGroupRequest.setGroupNameJsonSet(Collections.singletonList(bean));
        try {
            this.tubeMqOptService.createNewConsumerGroup(addTubeConsumeGroupRequest);
        }
        catch (Exception e) {
            throw new WorkflowListenerException("failed to create tube consumer group: " + addTubeConsumeGroupRequest);
        }
    }

    public boolean async() {
        return false;
    }
}

