/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.consumption.listener;

import java.util.Date;
import org.apache.inlong.manager.common.enums.ConsumptionStatus;
import org.apache.inlong.manager.common.event.ListenerResult;
import org.apache.inlong.manager.common.event.process.ProcessEvent;
import org.apache.inlong.manager.common.event.process.ProcessEventListener;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.model.WorkflowContext;
import org.apache.inlong.manager.dao.entity.ConsumptionEntity;
import org.apache.inlong.manager.dao.mapper.ConsumptionEntityMapper;
import org.apache.inlong.manager.service.workflow.consumption.NewConsumptionWorkflowForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsumptionRejectProcessListener
implements ProcessEventListener {
    private ConsumptionEntityMapper consumptionEntityMapper;

    @Autowired
    public ConsumptionRejectProcessListener(ConsumptionEntityMapper consumptionEntityMapper) {
        this.consumptionEntityMapper = consumptionEntityMapper;
    }

    public ProcessEvent event() {
        return ProcessEvent.REJECT;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        NewConsumptionWorkflowForm workflowForm = (NewConsumptionWorkflowForm)context.getProcessForm();
        ConsumptionEntity update = new ConsumptionEntity();
        update.setId(workflowForm.getConsumptionInfo().getId());
        update.setStatus(Integer.valueOf(ConsumptionStatus.REJECTED.getStatus()));
        update.setModifyTime(new Date());
        this.consumptionEntityMapper.updateByPrimaryKeySelective(update);
        return ListenerResult.success((String)"The application process was rejected");
    }

    public boolean async() {
        return false;
    }
}

