/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class CommandLineRunnerImpl
implements CommandLineRunner {
    private static final String PROJECT_PACKAGE = "org.apache.inlong.manager.common.pojo";
    @Autowired
    private ObjectMapper objectMapper;

    public void run(String[] args) {
        this.initJsonTypeDefine();
    }

    private void initJsonTypeDefine() {
        Reflections reflections = new Reflections(PROJECT_PACKAGE, new Scanner[0]);
        Set typeSet = reflections.getTypesAnnotatedWith(JsonTypeInfo.class);
        for (Class type : typeSet) {
            Set clazzSet = reflections.getSubTypesOf(type);
            if (CollectionUtils.isEmpty((Collection)clazzSet)) continue;
            for (Object obj : clazzSet) {
                JsonTypeDefine extendClassDefine;
                Class clazz = (Class)obj;
                if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || (extendClassDefine = clazz.getAnnotation(JsonTypeDefine.class)) == null) continue;
                this.objectMapper.registerSubtypes(new NamedType[]{new NamedType(clazz, extendClassDefine.value())});
            }
        }
    }
}

