/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.pojo.dataproxy.PulsarClusterInfo;
import org.apache.inlong.manager.common.beans.ClusterBean;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupState;
import org.apache.inlong.manager.common.enums.MQType;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.sink.SinkResponse;
import org.apache.inlong.manager.common.pojo.source.SourceResponse;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.ThirdPartyClusterEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.ThirdPartyClusterEntityMapper;
import org.apache.inlong.manager.service.core.InlongStreamService;
import org.apache.inlong.manager.service.source.StreamSourceService;
import org.apache.inlong.manager.service.thirdparty.sort.util.FieldInfoUtils;
import org.apache.inlong.manager.service.thirdparty.sort.util.SinkInfoUtils;
import org.apache.inlong.manager.service.thirdparty.sort.util.SourceInfoUtils;
import org.apache.inlong.sort.protocol.DataFlowInfo;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.sink.SinkInfo;
import org.apache.inlong.sort.protocol.source.SourceInfo;
import org.apache.inlong.sort.protocol.transformation.FieldMappingRule;
import org.apache.inlong.sort.protocol.transformation.TransformationInfo;
import org.apache.inlong.sort.protocol.transformation.TransformationRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonOperateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonOperateService.class);
    @Autowired
    private ClusterBean clusterBean;
    @Autowired
    private InlongStreamService streamService;
    @Autowired
    private StreamSourceService streamSourceService;
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private ThirdPartyClusterEntityMapper thirdPartyClusterMapper;

    public String getSpecifiedParam(String key) {
        String result = "";
        Gson gson = new Gson();
        switch (key) {
            case "pulsar_serviceUrl": {
                ThirdPartyClusterEntity clusterEntity = this.getMQCluster(MQType.PULSAR);
                if (clusterEntity == null) break;
                result = clusterEntity.getUrl();
                break;
            }
            case "pulsar_adminUrl": {
                ThirdPartyClusterEntity clusterEntity = this.getMQCluster(MQType.PULSAR);
                if (clusterEntity == null) break;
                Map params = (Map)gson.fromJson(clusterEntity.getExtParams(), Map.class);
                result = (String)params.get(key);
                break;
            }
            case "cluster_tube_manager": 
            case "cluster_tube_clusterId": 
            case "tube_masterUrl": {
                ThirdPartyClusterEntity clusterEntity = this.getMQCluster(MQType.TUBE);
                if (clusterEntity == null) break;
                if (key.equals("tube_masterUrl")) {
                    result = clusterEntity.getUrl();
                    break;
                }
                Map params = (Map)gson.fromJson(clusterEntity.getExtParams(), Map.class);
                result = (String)params.get(key);
                break;
            }
            default: {
                LOGGER.warn("case warn key {}", (Object)key);
            }
        }
        return result;
    }

    private ThirdPartyClusterEntity getMQCluster(MQType type) {
        List clusterList = this.thirdPartyClusterMapper.selectByType("DATA_PROXY");
        if (CollectionUtils.isEmpty((Collection)clusterList)) {
            LOGGER.warn("no data proxy cluster found");
            return null;
        }
        String mqSetName = ((ThirdPartyClusterEntity)clusterList.get(0)).getMqSetName();
        List mqClusterList = this.thirdPartyClusterMapper.selectMQCluster(mqSetName, Collections.singletonList(type.getType()));
        if (CollectionUtils.isEmpty((Collection)mqClusterList)) {
            LOGGER.warn("no mq cluster found by type={} and mq set name={}", (Object)type, (Object)mqSetName);
            return null;
        }
        return (ThirdPartyClusterEntity)mqClusterList.get(0);
    }

    public PulsarClusterInfo getPulsarClusterInfo(String type) {
        MQType mqType = MQType.forType((String)type);
        ThirdPartyClusterEntity clusterEntity = this.getMQCluster(mqType);
        if (clusterEntity == null || StringUtils.isBlank((CharSequence)clusterEntity.getExtParams())) {
            throw new BusinessException("pulsar cluster or pulsar ext params is empty");
        }
        Map configParams = (Map)JsonUtils.parse((String)clusterEntity.getExtParams(), Map.class);
        PulsarClusterInfo pulsarClusterInfo = PulsarClusterInfo.builder().brokerServiceUrl(clusterEntity.getUrl()).token(clusterEntity.getToken()).build();
        String adminUrl = (String)configParams.get("pulsar_adminUrl");
        Preconditions.checkNotNull((Object)adminUrl, (String)"adminUrl is empty, check third party cluster table");
        pulsarClusterInfo.setAdminUrl(adminUrl);
        pulsarClusterInfo.setType(clusterEntity.getType());
        return pulsarClusterInfo;
    }

    public InlongGroupEntity checkGroupStatus(String groupId, String operator) {
        InlongGroupEntity inlongGroupEntity = this.groupMapper.selectByGroupId(groupId);
        Preconditions.checkNotNull((Object)inlongGroupEntity, (String)"groupId is invalid");
        List<String> managers = Arrays.asList(inlongGroupEntity.getInCharges().split(","));
        Preconditions.checkTrue((boolean)managers.contains(operator), (String)String.format(ErrorCodeEnum.USER_IS_NOT_MANAGER.getMessage(), operator, managers));
        GroupState state = GroupState.forCode((int)inlongGroupEntity.getStatus());
        if (GroupState.notAllowedUpdate((GroupState)state)) {
            LOGGER.error("inlong group status was not allowed to add/update/delete related info");
            throw new BusinessException(ErrorCodeEnum.OPT_NOT_ALLOWED_BY_STATUS);
        }
        return inlongGroupEntity;
    }

    public DataFlowInfo createDataFlow(InlongGroupInfo groupInfo, SinkResponse sinkResponse) {
        String streamId;
        String groupId = sinkResponse.getInlongGroupId();
        List<SourceResponse> sourceList = this.streamSourceService.listSource(groupId, streamId = sinkResponse.getInlongStreamId());
        if (CollectionUtils.isEmpty(sourceList)) {
            throw new WorkflowListenerException(String.format("Source not found by groupId=%s and streamId=%s", groupId, streamId));
        }
        ArrayList<FieldInfo> sourceFields = new ArrayList<FieldInfo>();
        ArrayList<FieldInfo> sinkFields = new ArrayList<FieldInfo>();
        SourceResponse sourceResponse = sourceList.get(0);
        boolean isAllMigration = SourceInfoUtils.isBinlogAllMigration(sourceResponse);
        InlongStreamInfo streamInfo = this.streamService.get(groupId, streamId);
        List<FieldMappingRule.FieldMappingUnit> mappingUnitList = isAllMigration ? FieldInfoUtils.setAllMigrationFieldMapping(sourceFields, sinkFields) : FieldInfoUtils.createFieldInfo(streamInfo.getFieldList(), sinkResponse.getFieldList(), sourceFields, sinkFields);
        FieldMappingRule fieldMappingRule = new FieldMappingRule(mappingUnitList.toArray(new FieldMappingRule.FieldMappingUnit[0]));
        String masterAddress = this.getSpecifiedParam("tube_masterUrl");
        PulsarClusterInfo pulsarCluster = this.getPulsarClusterInfo(groupInfo.getMiddlewareType());
        SourceInfo sourceInfo = SourceInfoUtils.createSourceInfo(pulsarCluster, masterAddress, this.clusterBean, groupInfo, streamInfo, sourceResponse, sourceFields);
        SinkInfo sinkInfo = SinkInfoUtils.createSinkInfo(sourceResponse, sinkResponse, sinkFields);
        TransformationInfo transInfo = new TransformationInfo((TransformationRule)fieldMappingRule);
        HashMap<String, String> properties = new HashMap<String, String>();
        if (MapUtils.isNotEmpty((Map)sinkResponse.getProperties())) {
            properties.putAll(sinkResponse.getProperties());
        }
        properties.put("inlong.group.id", groupId);
        return new DataFlowInfo((long)sinkResponse.getId().intValue(), sourceInfo, transInfo, sinkInfo, properties);
    }
}

