/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.google.gson.Gson;
import org.apache.inlong.common.pojo.dataproxy.DataProxyCluster;
import org.apache.inlong.common.pojo.dataproxy.DataProxyConfigResponse;
import org.apache.inlong.manager.common.pojo.dataproxy.DataProxyClusterSet;
import org.apache.inlong.manager.service.core.DataProxyClusterService;
import org.apache.inlong.manager.service.repository.DataProxyConfigRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataProxyClusterServiceImpl
implements DataProxyClusterService {
    private static final Logger log = LoggerFactory.getLogger(DataProxyClusterServiceImpl.class);
    @Autowired
    private DataProxyConfigRepository proxyRepository;

    @Override
    public String getAllConfig(String clusterName, String setName, String md5) {
        DataProxyClusterSet setObj = this.proxyRepository.getDataProxyClusterSet(setName);
        if (setObj == null) {
            return this.getErrorAllConfig();
        }
        String configMd5 = (String)setObj.getMd5Map().get(clusterName);
        if (configMd5 == null) {
            return this.getErrorAllConfig();
        }
        if (md5 != null && configMd5.equals(md5)) {
            DataProxyConfigResponse response = new DataProxyConfigResponse();
            response.setResult(Boolean.valueOf(true));
            response.setErrCode(Integer.valueOf(1));
            response.setMd5(configMd5);
            response.setData(new DataProxyCluster());
            Gson gson = new Gson();
            return gson.toJson((Object)response);
        }
        String configJson = (String)setObj.getProxyConfigJson().get(clusterName);
        if (configJson == null) {
            return this.getErrorAllConfig();
        }
        return configJson;
    }

    private String getErrorAllConfig() {
        DataProxyConfigResponse response = new DataProxyConfigResponse();
        response.setResult(Boolean.valueOf(false));
        response.setErrCode(Integer.valueOf(-101));
        Gson gson = new Gson();
        return gson.toJson((Object)response);
    }
}

