/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.query.ColumnInfoBean;
import org.apache.inlong.manager.common.pojo.query.ConnectionInfo;
import org.apache.inlong.manager.common.pojo.query.DatabaseDetail;
import org.apache.inlong.manager.common.pojo.query.DatabaseQueryBean;
import org.apache.inlong.manager.common.pojo.query.hive.HiveTableQueryBean;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.HiveServerDao;
import org.apache.inlong.manager.service.core.DataSourceService;
import org.apache.inlong.manager.service.thirdparty.hive.builder.HiveAddColumnSqlBuilder;
import org.apache.inlong.manager.service.thirdparty.hive.builder.HiveChangeColumnBuilder;
import org.apache.inlong.manager.service.thirdparty.hive.builder.HiveCreateDbSqlBuilder;
import org.apache.inlong.manager.service.thirdparty.hive.builder.HiveDropDbSqlBuilder;
import org.apache.inlong.manager.service.thirdparty.hive.builder.HiveDropTableSqlBuilder;
import org.apache.inlong.manager.service.thirdparty.hive.builder.HiveQueryTableSqlBuilder;
import org.apache.inlong.manager.service.thirdparty.hive.builder.HiveTableCreateSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HiveSourceServiceImpl
implements DataSourceService<DatabaseQueryBean, HiveTableQueryBean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveSourceServiceImpl.class);
    @Autowired
    HiveServerDao hiveServerDao;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean testConnection(ConnectionInfo connectionInfo) {
        LOGGER.debug("begin test connection, connection info: {}", (Object)connectionInfo);
        Preconditions.checkNotNull((Object)connectionInfo, (String)"Connection info cannot be empty");
        Preconditions.checkNotNull((Object)connectionInfo.getJdbcUrl(), (String)"JDBC URL cannot be empty");
        try (Connection conn = this.hiveServerDao.getHiveConnection(connectionInfo.getJdbcUrl(), connectionInfo.getUsername(), connectionInfo.getPassword());){
            LOGGER.info("test connection success");
            boolean bl = conn != null;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("test connection error: {}", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public void createDb(HiveTableQueryBean bean) throws Exception {
        HiveCreateDbSqlBuilder builder = new HiveCreateDbSqlBuilder();
        String createDbSql = builder.buildDDL(bean);
        LOGGER.info("create database sql={}", (Object)createDbSql);
        this.hiveServerDao.executeDDL(createDbSql, bean.getJdbcUrl(), bean.getUsername(), bean.getPassword());
    }

    @Override
    public void dropDb(DatabaseQueryBean bean) throws Exception {
        HiveDropDbSqlBuilder builder = new HiveDropDbSqlBuilder();
        String dropDbSql = builder.buildDDL(bean);
        LOGGER.info("drop database sql={}", (Object)dropDbSql);
        this.hiveServerDao.executeDDL(dropDbSql, bean.getJdbcUrl(), bean.getUserName(), bean.getPassword());
    }

    @Override
    public void createTable(HiveTableQueryBean bean) throws Exception {
        HiveTableCreateSqlBuilder builder = new HiveTableCreateSqlBuilder();
        String createTableSql = builder.buildDDL(bean);
        LOGGER.info("create table sql={}", (Object)createTableSql);
        this.hiveServerDao.executeDDL(createTableSql, bean.getJdbcUrl(), bean.getUsername(), bean.getPassword());
    }

    @Override
    public void dropTable(HiveTableQueryBean bean) throws Exception {
        HiveDropTableSqlBuilder builder = new HiveDropTableSqlBuilder();
        String dropTableSql = builder.buildDDL(bean);
        LOGGER.info("drop table sql={}", (Object)dropTableSql);
        this.hiveServerDao.executeDDL(dropTableSql, bean.getJdbcUrl(), bean.getUsername(), bean.getPassword());
    }

    @Override
    public void createColumn(HiveTableQueryBean bean) throws Exception {
        if (bean == null) {
            LOGGER.warn("add table column failed: change info is null");
            return;
        }
        if (bean.getColumns() == null) {
            LOGGER.warn("add table column failed: columns is empty");
            return;
        }
        HiveAddColumnSqlBuilder builder = new HiveAddColumnSqlBuilder();
        String addColumnSql = builder.buildDDL(bean);
        LOGGER.info("add table Column sql={}", (Object)addColumnSql);
        this.hiveServerDao.executeDDL(addColumnSql, bean.getJdbcUrl(), bean.getUsername(), bean.getPassword());
    }

    @Override
    public void updateColumn(HiveTableQueryBean tableQueryBean) throws Exception {
        if (tableQueryBean == null) {
            LOGGER.warn("update table column failed: change info is null");
            return;
        }
        if (StringUtils.isBlank((CharSequence)tableQueryBean.getObjectId())) {
            LOGGER.warn("update table column failed: table objectId is null");
        }
        if (tableQueryBean.getColumns() == null) {
            LOGGER.warn("update table column failed: columns is empty");
            return;
        }
        if (tableQueryBean.getColumns().size() > 1) {
            LOGGER.warn("update table column failed: columns number is more than one, only support one column");
        }
        HiveChangeColumnBuilder builder = new HiveChangeColumnBuilder();
        String updateColumnSql = builder.buildDDL(tableQueryBean);
        LOGGER.info("update table Column sql={}", (Object)updateColumnSql);
        this.hiveServerDao.executeDDL(updateColumnSql, tableQueryBean.getJdbcUrl(), tableQueryBean.getUsername(), tableQueryBean.getPassword());
    }

    @Override
    public void dropColumn(HiveTableQueryBean queryBean) {
    }

    @Override
    public List<ColumnInfoBean> queryColumns(HiveTableQueryBean queryBean) throws Exception {
        String jdbcUrl = queryBean.getJdbcUrl();
        String username = queryBean.getUsername();
        String password = queryBean.getPassword();
        HiveQueryTableSqlBuilder tableBuilder = new HiveQueryTableSqlBuilder();
        String querySql = tableBuilder.buildDDL(queryBean);
        LOGGER.info("query sql={}", (Object)querySql);
        if (querySql != null && this.hiveServerDao.isExistTable(jdbcUrl, username, password, queryBean.getDbName(), queryBean.getTableName())) {
            return this.hiveServerDao.queryStructure(querySql, jdbcUrl, username, password);
        }
        return Collections.emptyList();
    }

    @Override
    public DatabaseDetail queryDbDetail(HiveTableQueryBean queryBean) {
        DatabaseDetail databaseDetail;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to query database info for {}", (Object)queryBean);
        }
        try {
            String jdbcUrl = queryBean.getJdbcUrl();
            String username = queryBean.getUsername();
            String password = queryBean.getPassword();
            List tableNames = this.hiveServerDao.getTables(jdbcUrl, username, password, queryBean.getDbName());
            databaseDetail = new DatabaseDetail(queryBean.getDbName(), tableNames);
            LOGGER.info("success to query db detail");
        }
        catch (Exception e) {
            LOGGER.error("query db detail error, ", (Throwable)e);
            throw new BusinessException(ErrorCodeEnum.HIVE_OPERATION_FAILED);
        }
        LOGGER.info("success to query database");
        return databaseDetail;
    }
}

