/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.manager.common.enums.GroupState;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.stream.StreamBriefResponse;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowResult;
import org.apache.inlong.manager.common.pojo.workflow.form.NewGroupProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.UpdateGroupProcessForm;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.apache.inlong.manager.service.core.InlongGroupService;
import org.apache.inlong.manager.service.core.InlongStreamService;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InlongGroupProcessOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlongGroupProcessOperation.class);
    private final ExecutorService executorService = new ThreadPoolExecutor(20, 40, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("inlong-group-process-%s").build(), new ThreadPoolExecutor.CallerRunsPolicy());
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private InlongStreamService streamService;
    @Autowired
    private InlongStreamEntityMapper streamMapper;

    public WorkflowResult startProcess(String groupId, String operator) {
        LOGGER.info("begin to start approve process, groupId = {}, operator = {}", (Object)groupId, (Object)operator);
        this.groupService.updateStatus(groupId, GroupState.TO_BE_APPROVAL.getCode(), operator);
        NewGroupProcessForm form = this.genNewGroupProcessForm(groupId);
        return this.workflowService.start(ProcessName.NEW_GROUP_PROCESS, operator, (ProcessForm)form);
    }

    public String suspendProcessAsync(String groupId, String operator) {
        LOGGER.info("begin to suspend process asynchronously, groupId = {}, operator = {}", (Object)groupId, (Object)operator);
        this.groupService.updateStatus(groupId, GroupState.SUSPENDING.getCode(), operator);
        UpdateGroupProcessForm form = this.genUpdateGroupProcessForm(groupId, UpdateGroupProcessForm.OperateType.SUSPEND);
        this.executorService.execute(() -> this.workflowService.start(ProcessName.SUSPEND_GROUP_PROCESS, operator, (ProcessForm)form));
        return groupId;
    }

    public WorkflowResult suspendProcess(String groupId, String operator) {
        LOGGER.info("begin to suspend process, groupId = {}, operator = {}", (Object)groupId, (Object)operator);
        this.groupService.updateStatus(groupId, GroupState.SUSPENDING.getCode(), operator);
        UpdateGroupProcessForm form = this.genUpdateGroupProcessForm(groupId, UpdateGroupProcessForm.OperateType.SUSPEND);
        return this.workflowService.start(ProcessName.SUSPEND_GROUP_PROCESS, operator, (ProcessForm)form);
    }

    public String restartProcessAsync(String groupId, String operator) {
        LOGGER.info("begin to restart process asynchronously, groupId = {}, operator = {}", (Object)groupId, (Object)operator);
        this.groupService.updateStatus(groupId, GroupState.RESTARTING.getCode(), operator);
        UpdateGroupProcessForm form = this.genUpdateGroupProcessForm(groupId, UpdateGroupProcessForm.OperateType.RESTART);
        this.executorService.execute(() -> this.workflowService.start(ProcessName.RESTART_GROUP_PROCESS, operator, (ProcessForm)form));
        return groupId;
    }

    public WorkflowResult restartProcess(String groupId, String operator) {
        LOGGER.info("begin to restart process, groupId = {}, operator = {}", (Object)groupId, (Object)operator);
        this.groupService.updateStatus(groupId, GroupState.RESTARTING.getCode(), operator);
        UpdateGroupProcessForm form = this.genUpdateGroupProcessForm(groupId, UpdateGroupProcessForm.OperateType.RESTART);
        return this.workflowService.start(ProcessName.RESTART_GROUP_PROCESS, operator, (ProcessForm)form);
    }

    public String deleteProcessAsync(String groupId, String operator) {
        LOGGER.info("begin to delete process asynchronously, groupId = {}, operator = {}", (Object)groupId, (Object)operator);
        this.executorService.execute(() -> {
            try {
                UpdateGroupProcessForm form = this.genUpdateGroupProcessForm(groupId, UpdateGroupProcessForm.OperateType.DELETE);
                this.workflowService.start(ProcessName.DELETE_GROUP_PROCESS, operator, (ProcessForm)form);
            }
            catch (Exception ex) {
                LOGGER.error("exception while delete process, groupId = {}, operator = {}", new Object[]{groupId, operator, ex});
                throw ex;
            }
            this.groupService.delete(groupId, operator);
        });
        return groupId;
    }

    public boolean deleteProcess(String groupId, String operator) {
        LOGGER.info("begin to delete process, groupId = {}, operator = {}", (Object)groupId, (Object)operator);
        try {
            UpdateGroupProcessForm form = this.genUpdateGroupProcessForm(groupId, UpdateGroupProcessForm.OperateType.DELETE);
            this.workflowService.start(ProcessName.DELETE_GROUP_PROCESS, operator, (ProcessForm)form);
        }
        catch (Exception ex) {
            LOGGER.error("exception while delete process, groupId = {}, operator = {}", new Object[]{groupId, operator, ex});
            throw ex;
        }
        return this.groupService.delete(groupId, operator);
    }

    public NewGroupProcessForm genNewGroupProcessForm(String groupId) {
        NewGroupProcessForm form = new NewGroupProcessForm();
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        form.setGroupInfo(groupInfo);
        List<StreamBriefResponse> infoList = this.streamService.getBriefList(groupInfo.getInlongGroupId());
        form.setStreamInfoList(infoList);
        return form;
    }

    private UpdateGroupProcessForm genUpdateGroupProcessForm(String groupId, UpdateGroupProcessForm.OperateType operateType) {
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        UpdateGroupProcessForm form = new UpdateGroupProcessForm();
        if (UpdateGroupProcessForm.OperateType.RESTART == operateType) {
            List inlongStreamEntityList = this.streamMapper.selectByGroupId(groupInfo.getInlongGroupId());
            List streamList = CommonBeanUtils.copyListProperties((List)inlongStreamEntityList, InlongStreamInfo::new);
            form.setStreamList(streamList);
        }
        form.setGroupInfo(groupInfo);
        form.setOperateType(operateType);
        return form;
    }
}

