/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.pojo.sdk.CacheZone;
import org.apache.inlong.common.pojo.sdk.CacheZoneConfig;
import org.apache.inlong.common.pojo.sdk.SortSourceConfigResponse;
import org.apache.inlong.common.pojo.sortstandalone.SortClusterConfig;
import org.apache.inlong.common.pojo.sortstandalone.SortClusterResponse;
import org.apache.inlong.common.pojo.sortstandalone.SortTaskConfig;
import org.apache.inlong.manager.dao.entity.SortClusterConfigEntity;
import org.apache.inlong.manager.service.core.SortClusterConfigService;
import org.apache.inlong.manager.service.core.SortService;
import org.apache.inlong.manager.service.core.SortSourceService;
import org.apache.inlong.manager.service.core.SortTaskIdParamService;
import org.apache.inlong.manager.service.core.SortTaskSinkParamService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SortServiceImpl
implements SortService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortServiceImpl.class);
    private static final int RESPONSE_CODE_SUCCESS = 0;
    private static final int RESPONSE_CODE_NO_UPDATE = 1;
    private static final int RESPONSE_CODE_FAIL = -1;
    private static final int RESPONSE_CODE_REQ_PARAMS_ERROR = -101;
    @Autowired
    private SortClusterConfigService sortClusterConfigService;
    @Autowired
    private SortTaskIdParamService sortTaskIdParamService;
    @Autowired
    private SortTaskSinkParamService sortTaskSinkParamService;
    @Autowired
    private SortSourceService sortSourceService;

    @Override
    public SortClusterResponse getClusterConfig(String clusterName, String md5) {
        LOGGER.info("start getClusterConfig");
        if (StringUtils.isBlank((CharSequence)clusterName)) {
            String errMsg = "Blank cluster name, return nothing";
            LOGGER.info(errMsg);
            return SortClusterResponse.builder().msg(errMsg).build();
        }
        List<SortClusterConfigEntity> tasks = this.sortClusterConfigService.selectTasksByClusterName(clusterName);
        if (tasks == null || tasks.isEmpty()) {
            String errMsg = "There is not any task for cluster" + clusterName;
            LOGGER.info(errMsg);
            return SortClusterResponse.builder().code(-101).msg(errMsg).build();
        }
        ArrayList taskConfigs = new ArrayList();
        try {
            tasks.forEach(clusterConfig -> taskConfigs.add(this.getTaskConfig((SortClusterConfigEntity)clusterConfig)));
        }
        catch (IllegalArgumentException ex) {
            String errMsg = "Got illegal sink type from db, " + ex.getMessage();
            LOGGER.info(errMsg);
            return SortClusterResponse.builder().code(-1).msg(errMsg).build();
        }
        SortClusterConfig clusterConfig2 = SortClusterConfig.builder().clusterName(clusterName).sortTasks(taskConfigs).build();
        JSONObject job = new JSONObject((Object)clusterConfig2);
        String localMd5 = DigestUtils.md5Hex((String)job.toString());
        if (localMd5.equals(md5)) {
            return SortClusterResponse.builder().code(1).msg("No update").md5(localMd5).build();
        }
        return SortClusterResponse.builder().code(0).data(clusterConfig2).msg("success").md5(localMd5).build();
    }

    private SortTaskConfig getTaskConfig(SortClusterConfigEntity clusterConfig) {
        String sinkType = clusterConfig.getSinkType().toUpperCase();
        List<Map<String, String>> idParams = this.sortTaskIdParamService.selectByTaskName(clusterConfig.getTaskName());
        Map<String, String> sinkParams = this.sortTaskSinkParamService.selectByTaskNameAndType(clusterConfig.getTaskName(), clusterConfig.getSinkType());
        return SortTaskConfig.builder().name(clusterConfig.getTaskName()).type(sinkType).idParams(idParams).sinkParams(sinkParams).build();
    }

    @Override
    public SortSourceConfigResponse getSourceConfig(String clusterName, String sortTaskId, String md5) {
        Map<String, CacheZone> cacheZones;
        if (StringUtils.isBlank((CharSequence)clusterName) || StringUtils.isBlank((CharSequence)sortTaskId)) {
            String errMsg = "Blank cluster name or task id, return nothing";
            return SortSourceConfigResponse.builder().msg(errMsg).code(-101).build();
        }
        try {
            cacheZones = this.sortSourceService.getCacheZones(clusterName, sortTaskId);
        }
        catch (Exception e) {
            String errMsg = "Got exception when get cache zones. " + e.getMessage();
            LOGGER.error(errMsg, (Throwable)e);
            return SortSourceConfigResponse.builder().msg(errMsg).code(-1).build();
        }
        if (cacheZones.isEmpty()) {
            String errMsg = "There is not any cacheZones of cluster: " + clusterName + " , task: " + sortTaskId + " , please check the params";
            LOGGER.error(errMsg);
            return SortSourceConfigResponse.builder().msg(errMsg).code(-101).build();
        }
        CacheZoneConfig data = CacheZoneConfig.builder().sortClusterName(clusterName).sortTaskId(sortTaskId).cacheZones(cacheZones).build();
        JSONObject jo = new JSONObject((Object)data);
        String localMd5 = DigestUtils.md5Hex((String)jo.toString());
        if (md5.equals(localMd5)) {
            String msg = "Same md5, no update";
            return SortSourceConfigResponse.builder().msg(msg).code(1).md5(md5).build();
        }
        return SortSourceConfigResponse.builder().msg("success").code(0).data(data).md5(localMd5).build();
    }
}

