/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamConfigLogListResponse;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamConfigLogPageRequest;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamConfigLogRequest;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.StreamConfigLogEntity;
import org.apache.inlong.manager.dao.mapper.StreamConfigLogEntityMapper;
import org.apache.inlong.manager.service.core.StreamConfigLogService;
import org.apache.inlong.manager.service.core.impl.AbstractService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StreamConfigLogServiceImpl
extends AbstractService<StreamConfigLogEntity>
implements StreamConfigLogService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamConfigLogServiceImpl.class);
    @Autowired
    private StreamConfigLogEntityMapper streamConfigLogEntityMapper;

    @Override
    public String reportConfigLog(InlongStreamConfigLogRequest request) {
        if (this.putData(this.convertData(request))) {
            return "Receive success";
        }
        LOGGER.warn("Receive Queue is full, data will be discarded !");
        return "Receive Queue is full, data will be discarded !";
    }

    @Override
    public PageInfo<InlongStreamConfigLogListResponse> listByCondition(InlongStreamConfigLogPageRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to list source page by " + request);
        }
        Preconditions.checkNotNull((Object)request.getInlongGroupId(), (String)"inlong group id is empty");
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        if (request.getReportTime() == null) {
            Instant instant = Instant.now().minus(Duration.ofMillis(5L));
            request.setReportTime(new Date(instant.toEpochMilli()));
        }
        Page entityPage = (Page)this.streamConfigLogEntityMapper.selectByCondition(request);
        List detailList = CommonBeanUtils.copyListProperties((List)entityPage, InlongStreamConfigLogListResponse::new);
        PageInfo pageInfo = new PageInfo(detailList);
        pageInfo.setTotal(entityPage.getTotal());
        return pageInfo;
    }

    @Override
    public boolean batchInsertEntities(List<StreamConfigLogEntity> entryList) {
        this.streamConfigLogEntityMapper.insertOrUpdateAll(entryList);
        return true;
    }

    public StreamConfigLogEntity convertData(InlongStreamConfigLogRequest request) {
        StreamConfigLogEntity entity = new StreamConfigLogEntity();
        entity.setComponentName(request.getComponentName());
        entity.setInlongGroupId(request.getInlongGroupId());
        entity.setInlongStreamId(request.getInlongStreamId());
        entity.setConfigName(request.getConfigName());
        entity.setReportTime(new Date(request.getReportTime()));
        entity.setVersion(request.getVersion());
        entity.setLogInfo(request.getLogInfo());
        entity.setLogType(request.getLogType());
        entity.setIp(request.getIp());
        return entity;
    }
}

