/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.pojo.dataproxy.DataProxyConfig;
import org.apache.inlong.common.pojo.dataproxy.ThirdPartyClusterDTO;
import org.apache.inlong.common.pojo.dataproxy.ThirdPartyClusterInfo;
import org.apache.inlong.manager.common.beans.ClusterBean;
import org.apache.inlong.manager.common.enums.Constant;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupState;
import org.apache.inlong.manager.common.enums.MQType;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.cluster.ClusterPageRequest;
import org.apache.inlong.manager.common.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.common.pojo.cluster.ClusterResponse;
import org.apache.inlong.manager.common.pojo.dataproxy.DataProxyResponse;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.InLongStringUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.InlongGroupPulsarEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamEntity;
import org.apache.inlong.manager.dao.entity.ThirdPartyClusterEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongGroupPulsarEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.apache.inlong.manager.dao.mapper.ThirdPartyClusterEntityMapper;
import org.apache.inlong.manager.service.core.ThirdPartyClusterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ThirdPartyClusterServiceImpl
implements ThirdPartyClusterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdPartyClusterServiceImpl.class);
    private static final Gson GSON = new Gson();
    @Autowired
    private ClusterBean clusterBean;
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private InlongGroupPulsarEntityMapper pulsarEntityMapper;
    @Autowired
    private InlongStreamEntityMapper streamMapper;
    @Autowired
    private ThirdPartyClusterEntityMapper thirdPartyClusterMapper;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer save(ClusterRequest request, String operator) {
        LOGGER.info("begin to insert a cluster info cluster={}", (Object)request);
        Preconditions.checkNotNull((Object)request, (String)"cluster is empty");
        ThirdPartyClusterEntity exist = this.thirdPartyClusterMapper.selectByName(request.getName());
        Preconditions.checkTrue((exist == null ? 1 : 0) != 0, (String)"cluster name already exist");
        ThirdPartyClusterEntity entity = (ThirdPartyClusterEntity)CommonBeanUtils.copyProperties((Object)request, ThirdPartyClusterEntity::new);
        if (operator != null) {
            entity.setCreator(operator);
        }
        Preconditions.checkNotNull((Object)entity.getCreator(), (String)"cluster creator is empty");
        entity.setCreateTime(new Date());
        entity.setIsDeleted(Constant.UN_DELETED);
        this.thirdPartyClusterMapper.insert(entity);
        LOGGER.info("success to add a cluster");
        return entity.getId();
    }

    @Override
    public ClusterResponse get(Integer id) {
        LOGGER.info("begin to get cluster by id={}", (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"cluster id is empty");
        ThirdPartyClusterEntity entity = this.thirdPartyClusterMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("cluster not found by id={}", (Object)id);
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        ClusterResponse clusterResponse = (ClusterResponse)CommonBeanUtils.copyProperties((Object)entity, ClusterResponse::new);
        LOGGER.info("success to get cluster info");
        return clusterResponse;
    }

    @Override
    public PageInfo<ClusterResponse> list(ClusterPageRequest request) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.thirdPartyClusterMapper.selectByCondition(request);
        List clusterList = CommonBeanUtils.copyListProperties((List)entityPage, ClusterResponse::new);
        PageInfo page = new PageInfo(clusterList);
        page.setTotal(entityPage.getTotal());
        LOGGER.debug("success to list cluster by {}", (Object)request);
        return page;
    }

    @Override
    public List<String> listClusterIpByType(String type) {
        ClusterPageRequest request = new ClusterPageRequest();
        request.setType(type);
        List entityList = this.thirdPartyClusterMapper.selectByCondition(request);
        ArrayList<String> ipList = new ArrayList<String>(entityList.size());
        for (ThirdPartyClusterEntity entity : entityList) {
            ipList.add(entity.getIp());
        }
        return ipList;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean update(ClusterRequest request, String operator) {
        Preconditions.checkNotNull((Object)request, (String)"cluster is empty");
        Integer id = request.getId();
        Preconditions.checkNotNull((Object)id, (String)"cluster id is empty");
        ThirdPartyClusterEntity entity = this.thirdPartyClusterMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("cluster not found by id={}", (Object)id);
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        CommonBeanUtils.copyProperties((Object)request, (Object)entity, (boolean)true);
        entity.setModifier(operator);
        this.thirdPartyClusterMapper.updateByPrimaryKeySelective(entity);
        LOGGER.info("success to update cluster={}", (Object)request);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean delete(Integer id, String operator) {
        Preconditions.checkNotNull((Object)id, (String)"cluster id is empty");
        ThirdPartyClusterEntity entity = this.thirdPartyClusterMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("cluster not found by id={}", (Object)id);
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        entity.setIsDeleted(id);
        entity.setStatus(EntityStatus.DELETED.getCode());
        entity.setModifier(operator);
        this.thirdPartyClusterMapper.updateByPrimaryKey(entity);
        LOGGER.info("success to delete cluster by id={}", (Object)id);
        return true;
    }

    @Override
    public List<DataProxyResponse> getIpList(String clusterName) {
        ThirdPartyClusterEntity entity;
        LOGGER.debug("begin to list data proxy by clusterName={}", (Object)clusterName);
        if (StringUtils.isNotBlank((CharSequence)clusterName)) {
            entity = this.thirdPartyClusterMapper.selectByName(clusterName);
        } else {
            List list = this.thirdPartyClusterMapper.selectByType("DATA_PROXY");
            if (CollectionUtils.isEmpty((Collection)list)) {
                LOGGER.warn("data proxy cluster not found by type=DATA_PROXY");
                return null;
            }
            entity = (ThirdPartyClusterEntity)list.get(0);
        }
        if (entity == null || StringUtils.isBlank((CharSequence)entity.getIp())) {
            LOGGER.warn("data proxy cluster not found by name={}", (Object)clusterName);
            return null;
        }
        if (!"DATA_PROXY".equals(entity.getType())) {
            LOGGER.warn("expected cluster type is DATA_PROXY, but found {}", (Object)entity.getType());
            return null;
        }
        String ipStr = entity.getIp();
        while (ipStr.startsWith(",") || ipStr.endsWith(",") || ipStr.startsWith(":") || ipStr.endsWith(":")) {
            ipStr = InLongStringUtils.trimFirstAndLastChar((String)ipStr, (String)",");
            ipStr = InLongStringUtils.trimFirstAndLastChar((String)ipStr, (String)":");
        }
        ArrayList<DataProxyResponse> responseList = new ArrayList<DataProxyResponse>();
        Integer id = entity.getId();
        Integer defaultPort = entity.getPort();
        int index = ipStr.indexOf(",");
        if (index <= 0) {
            DataProxyResponse response = new DataProxyResponse();
            response.setId(id);
            this.setIpAndPort(ipStr, defaultPort, response);
            responseList.add(response);
        } else {
            String[] urlArr;
            for (String url : urlArr = ipStr.split(",")) {
                DataProxyResponse response = new DataProxyResponse();
                response.setId(id);
                this.setIpAndPort(url, defaultPort, response);
                responseList.add(response);
            }
        }
        LOGGER.debug("success to list data proxy cluster={}", responseList);
        return responseList;
    }

    private void setIpAndPort(String url, Integer defaultPort, DataProxyResponse response) {
        int idx = url.indexOf(":");
        if (idx <= 0) {
            response.setIp(url);
            response.setPort(defaultPort);
        } else {
            response.setIp(url.substring(0, idx));
            response.setPort(Integer.valueOf(url.substring(idx + 1)));
        }
    }

    @Override
    public List<DataProxyConfig> getConfig() {
        List groupEntityList = this.groupMapper.selectAll(GroupState.CONFIG_SUCCESSFUL.getCode());
        ArrayList<DataProxyConfig> configList = new ArrayList<DataProxyConfig>();
        for (InlongGroupEntity groupEntity : groupEntityList) {
            String groupId = groupEntity.getInlongGroupId();
            String bizResource = groupEntity.getMqResourceObj();
            DataProxyConfig config = new DataProxyConfig();
            config.setM(groupEntity.getSchemaName());
            MQType mqType = MQType.forType((String)groupEntity.getMiddlewareType());
            if (mqType == MQType.TUBE) {
                config.setInlongGroupId(groupId);
                config.setTopic(bizResource);
            } else if (mqType == MQType.PULSAR || mqType == MQType.TDMQ_PULSAR) {
                List streamList = this.streamMapper.selectByGroupId(groupId);
                for (InlongStreamEntity stream : streamList) {
                    String topic = stream.getMqResourceObj();
                    String streamId = stream.getInlongStreamId();
                    config.setInlongGroupId(groupId + "/" + streamId);
                    config.setTopic("persistent://" + this.clusterBean.getDefaultTenant() + "/" + bizResource + "/" + topic);
                }
            }
            configList.add(config);
        }
        return configList;
    }

    @Override
    public ThirdPartyClusterDTO getConfigV2(String clusterName) {
        ThirdPartyClusterEntity clusterEntity = this.thirdPartyClusterMapper.selectByName(clusterName);
        if (clusterEntity == null) {
            throw new BusinessException("data proxy cluster not found by name=" + clusterName);
        }
        ThirdPartyClusterDTO object = new ThirdPartyClusterDTO();
        List groupEntityList = this.groupMapper.selectAll(GroupState.CONFIG_SUCCESSFUL.getCode());
        if (CollectionUtils.isEmpty((Collection)groupEntityList)) {
            String msg = "not found any inlong group with success status for proxy cluster name = " + clusterName;
            LOGGER.warn(msg);
            return object;
        }
        String mqType = "";
        if (!groupEntityList.isEmpty()) {
            mqType = ((InlongGroupEntity)groupEntityList.get(0)).getMiddlewareType();
        }
        ArrayList<DataProxyConfig> topicList = new ArrayList<DataProxyConfig>();
        for (InlongGroupEntity groupEntity : groupEntityList) {
            String groupId = groupEntity.getInlongGroupId();
            String mqResource = groupEntity.getMqResourceObj();
            MQType type = MQType.forType((String)mqType);
            if (type == MQType.PULSAR || type == MQType.TDMQ_PULSAR) {
                List streamList = this.streamMapper.selectByGroupId(groupId);
                for (InlongStreamEntity stream : streamList) {
                    DataProxyConfig topicConfig = new DataProxyConfig();
                    String streamId = stream.getInlongStreamId();
                    String topic = stream.getMqResourceObj();
                    String tenant = this.clusterBean.getDefaultTenant();
                    InlongGroupPulsarEntity pulsarEntity = this.pulsarEntityMapper.selectByGroupId(groupId);
                    if (pulsarEntity != null && StringUtils.isNotEmpty((CharSequence)pulsarEntity.getTenant())) {
                        tenant = pulsarEntity.getTenant();
                    }
                    topicConfig.setInlongGroupId(groupId + "/" + streamId);
                    topicConfig.setTopic("persistent://" + tenant + "/" + mqResource + "/" + topic);
                    topicList.add(topicConfig);
                }
                continue;
            }
            if (type != MQType.TUBE) continue;
            DataProxyConfig topicConfig = new DataProxyConfig();
            topicConfig.setInlongGroupId(groupId);
            topicConfig.setTopic(mqResource);
            topicList.add(topicConfig);
        }
        ArrayList<ThirdPartyClusterInfo> mqSet = new ArrayList<ThirdPartyClusterInfo>();
        List<String> clusterType = Arrays.asList("TUBE", "PULSAR", "TDMQ_PULSAR");
        List clusterList = this.thirdPartyClusterMapper.selectMQCluster(clusterEntity.getMqSetName(), clusterType);
        for (ThirdPartyClusterEntity cluster : clusterList) {
            ThirdPartyClusterInfo clusterInfo = new ThirdPartyClusterInfo();
            clusterInfo.setUrl(cluster.getUrl());
            clusterInfo.setToken(cluster.getToken());
            Map configParams = (Map)GSON.fromJson(cluster.getExtParams(), Map.class);
            clusterInfo.setParams(configParams);
            mqSet.add(clusterInfo);
        }
        object.setMqSet(mqSet);
        object.setTopicList(topicList);
        return object;
    }
}

