/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sink;

import java.util.List;
import java.util.Optional;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.SinkType;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.service.sink.StreamSinkOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SinkOperationFactory {
    @Autowired
    private List<StreamSinkOperation> sinkOperationList;

    public StreamSinkOperation getInstance(SinkType sinkType) {
        Optional<StreamSinkOperation> instance = this.sinkOperationList.stream().filter(inst -> inst.accept(sinkType)).findFirst();
        if (!instance.isPresent()) {
            throw new BusinessException(ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT, String.format(ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT.getMessage(), sinkType));
        }
        return instance.get();
    }
}

