/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.Constant;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupState;
import org.apache.inlong.manager.common.enums.SourceState;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.source.SourceRequest;
import org.apache.inlong.manager.common.pojo.source.SourceResponse;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.dao.mapper.StreamSourceEntityMapper;
import org.apache.inlong.manager.service.source.StreamSourceOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractSourceOperation
implements StreamSourceOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSourceOperation.class);
    @Autowired
    protected StreamSourceEntityMapper sourceMapper;

    protected abstract void setTargetEntity(SourceRequest var1, StreamSourceEntity var2);

    protected abstract String getSourceType();

    protected abstract SourceResponse getResponse();

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer saveOpt(SourceRequest request, Integer groupStatus, String operator) {
        String sourceName;
        String streamId;
        String groupId = request.getInlongGroupId();
        List existList = this.sourceMapper.selectByRelatedId(groupId, streamId = request.getInlongStreamId(), sourceName = request.getSourceName());
        if (CollectionUtils.isNotEmpty((Collection)existList)) {
            String err = "stream source already exists with groupId=%s, streamId=%s, sourceName=%s";
            throw new BusinessException(String.format(err, groupId, streamId, sourceName));
        }
        StreamSourceEntity entity = (StreamSourceEntity)CommonBeanUtils.copyProperties((Object)request, StreamSourceEntity::new);
        entity.setVersion(Integer.valueOf(1));
        if (GroupState.forCode((int)groupStatus).equals((Object)GroupState.CONFIG_SUCCESSFUL)) {
            entity.setStatus(SourceState.TO_BE_ISSUED_ADD.getCode());
        } else {
            entity.setStatus(SourceState.SOURCE_NEW.getCode());
        }
        entity.setIsDeleted(Constant.UN_DELETED);
        entity.setCreator(operator);
        entity.setModifier(operator);
        Date now = new Date();
        entity.setCreateTime(now);
        entity.setModifyTime(now);
        this.setTargetEntity(request, entity);
        this.sourceMapper.insert(entity);
        return entity.getId();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.NOT_SUPPORTED)
    public SourceResponse getById(@NotNull Integer id) {
        StreamSourceEntity entity = this.sourceMapper.selectById(id);
        Preconditions.checkNotNull((Object)entity, (String)ErrorCodeEnum.SOURCE_INFO_NOT_FOUND.getMessage());
        String existType = entity.getSourceType();
        Preconditions.checkTrue((boolean)this.getSourceType().equals(existType), (String)String.format("Expected source type is %s, but found %s", this.getSourceType(), existType));
        return this.getFromEntity(entity, this::getResponse);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void updateOpt(SourceRequest request, Integer groupStatus, String operator) {
        StreamSourceEntity entity = this.sourceMapper.selectByIdForUpdate(request.getId());
        Preconditions.checkNotNull((Object)entity, (String)ErrorCodeEnum.SOURCE_INFO_NOT_FOUND.getMessage());
        if (!SourceState.ALLOWED_UPDATE.contains(entity.getStatus())) {
            throw new BusinessException(String.format("Source=%s is not allowed to update, please wait until its changed to final status or stop / frozen / delete it firstly", entity));
        }
        this.setTargetEntity(request, entity);
        entity.setVersion(Integer.valueOf(entity.getVersion() + 1));
        entity.setModifier(operator);
        entity.setModifyTime(new Date());
        this.sourceMapper.updateByPrimaryKeySelective(entity);
        LOGGER.info("success to update source of type={}", (Object)request.getSourceType());
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void stopOpt(SourceRequest request, String operator) {
        SourceState nextState;
        StreamSourceEntity existEntity = this.sourceMapper.selectByIdForUpdate(request.getId());
        SourceState curState = SourceState.forCode((int)existEntity.getStatus());
        if (!SourceState.isAllowedTransition((SourceState)curState, (SourceState)(nextState = SourceState.TO_BE_ISSUED_FROZEN))) {
            throw new BusinessException(String.format("Source=%s is not allowed to stop", existEntity));
        }
        StreamSourceEntity curEntity = (StreamSourceEntity)CommonBeanUtils.copyProperties((Object)request, StreamSourceEntity::new);
        curEntity.setVersion(Integer.valueOf(existEntity.getVersion() + 1));
        curEntity.setModifyTime(new Date());
        curEntity.setPreviousStatus(curState.getCode());
        curEntity.setStatus(nextState.getCode());
        this.sourceMapper.updateByPrimaryKeySelective(curEntity);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void restartOpt(SourceRequest request, String operator) {
        SourceState nextState;
        StreamSourceEntity existEntity = this.sourceMapper.selectByIdForUpdate(request.getId());
        SourceState curState = SourceState.forCode((int)existEntity.getStatus());
        if (!SourceState.isAllowedTransition((SourceState)curState, (SourceState)(nextState = SourceState.TO_BE_ISSUED_ACTIVE))) {
            throw new BusinessException(String.format("Source=%s is not allowed to restart", existEntity));
        }
        StreamSourceEntity curEntity = (StreamSourceEntity)CommonBeanUtils.copyProperties((Object)request, StreamSourceEntity::new);
        curEntity.setVersion(Integer.valueOf(existEntity.getVersion() + 1));
        curEntity.setModifyTime(new Date());
        curEntity.setPreviousStatus(curState.getCode());
        curEntity.setStatus(nextState.getCode());
        this.sourceMapper.updateByPrimaryKeySelective(curEntity);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void deleteOpt(SourceRequest request, String operator) {
        Integer id = request.getId();
        StreamSourceEntity existEntity = this.sourceMapper.selectByIdForUpdate(id);
        SourceState curState = SourceState.forCode((int)existEntity.getStatus());
        SourceState nextState = SourceState.TO_BE_ISSUED_DELETE;
        if (curState == SourceState.SOURCE_FROZEN || curState == SourceState.SOURCE_FAILED || curState == SourceState.SOURCE_NEW) {
            nextState = SourceState.SOURCE_DISABLE;
        }
        if (!SourceState.isAllowedTransition((SourceState)curState, (SourceState)nextState)) {
            throw new BusinessException(String.format("Source=%s is not allowed to delete", existEntity));
        }
        StreamSourceEntity curEntity = (StreamSourceEntity)CommonBeanUtils.copyProperties((Object)request, StreamSourceEntity::new);
        curEntity.setVersion(Integer.valueOf(existEntity.getVersion() + 1));
        curEntity.setPreviousStatus(curState.getCode());
        curEntity.setStatus(nextState.getCode());
        curEntity.setIsDeleted(id);
        curEntity.setModifyTime(new Date());
        this.sourceMapper.updateByPrimaryKeySelective(curEntity);
    }
}

