/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source;

import java.util.List;
import java.util.Optional;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.SourceType;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.service.source.StreamSourceOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SourceOperationFactory {
    @Autowired
    private List<StreamSourceOperation> sourceOperationList;

    public StreamSourceOperation getInstance(SourceType sourceType) {
        Optional<StreamSourceOperation> instance = this.sourceOperationList.stream().filter(inst -> inst.accept(sourceType)).findFirst();
        if (!instance.isPresent()) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_TYPE_NOT_SUPPORT, String.format(ErrorCodeEnum.SOURCE_TYPE_NOT_SUPPORT.getMessage(), sourceType));
        }
        return instance.get();
    }
}

