/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupState;
import org.apache.inlong.manager.common.enums.SourceState;
import org.apache.inlong.manager.common.enums.SourceType;
import org.apache.inlong.manager.common.pojo.source.SourceListResponse;
import org.apache.inlong.manager.common.pojo.source.SourcePageRequest;
import org.apache.inlong.manager.common.pojo.source.SourceRequest;
import org.apache.inlong.manager.common.pojo.source.SourceResponse;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.dao.mapper.StreamSourceEntityMapper;
import org.apache.inlong.manager.service.CommonOperateService;
import org.apache.inlong.manager.service.source.SourceOperationFactory;
import org.apache.inlong.manager.service.source.StreamSourceOperation;
import org.apache.inlong.manager.service.source.StreamSourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StreamSourceServiceImpl
implements StreamSourceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamSourceServiceImpl.class);
    @Autowired
    private SourceOperationFactory operationFactory;
    @Autowired
    private StreamSourceEntityMapper sourceMapper;
    @Autowired
    private CommonOperateService commonOperateService;

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW)
    public Integer save(SourceRequest request, String operator) {
        LOGGER.info("begin to save source info: {}", (Object)request);
        this.checkParams(request);
        String groupId = request.getInlongGroupId();
        InlongGroupEntity groupEntity = this.commonOperateService.checkGroupStatus(groupId, operator);
        String sourceType = request.getSourceType();
        StreamSourceOperation operation = this.operationFactory.getInstance(SourceType.forType((String)sourceType));
        int id = operation.saveOpt(request, groupEntity.getStatus(), operator);
        LOGGER.info("success to save source info: {}", (Object)request);
        return id;
    }

    @Override
    public SourceResponse get(Integer id, String sourceType) {
        StreamSourceOperation operation = this.operationFactory.getInstance(SourceType.forType((String)sourceType));
        SourceResponse sourceResponse = operation.getById(id);
        LOGGER.debug("success to get source by id={}", (Object)id);
        return sourceResponse;
    }

    @Override
    public Integer getCount(String groupId, String streamId) {
        Integer count = this.sourceMapper.selectCount(groupId, streamId);
        LOGGER.debug("source count={} with groupId={}, streamId={}", new Object[]{count, groupId, streamId});
        return count;
    }

    @Override
    public List<SourceResponse> listSource(String groupId, String streamId) {
        Preconditions.checkNotNull((Object)groupId, (String)"inlong group id is empty");
        List entityList = this.sourceMapper.selectByRelatedId(groupId, streamId, null);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return Collections.emptyList();
        }
        ArrayList<SourceResponse> responseList = new ArrayList<SourceResponse>();
        entityList.forEach(entity -> responseList.add(this.get(entity.getId(), entity.getSourceType())));
        LOGGER.debug("success to list source by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        return responseList;
    }

    @Override
    public PageInfo<? extends SourceListResponse> listByCondition(SourcePageRequest request) {
        Preconditions.checkNotNull((Object)request.getInlongGroupId(), (String)"inlong group id is empty");
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        List entityList = this.sourceMapper.selectByCondition(request);
        HashMap sourceMap = Maps.newHashMap();
        for (Object entity : entityList) {
            SourceType sourceType = SourceType.forType((String)entity.getSourceType());
            sourceMap.computeIfAbsent(sourceType, k -> new Page()).add(entity);
        }
        ArrayList responseList = Lists.newArrayList();
        for (Map.Entry entry : sourceMap.entrySet()) {
            SourceType sourceType = (SourceType)entry.getKey();
            StreamSourceOperation operation = this.operationFactory.getInstance(sourceType);
            PageInfo<? extends SourceListResponse> pageInfo = operation.getPageInfo((Page<StreamSourceEntity>)((Page)entry.getValue()));
            responseList.addAll(pageInfo.getList());
        }
        PageInfo pageInfo = PageInfo.of((List)responseList);
        LOGGER.debug("success to list source page, result size {}", (Object)pageInfo.getSize());
        return pageInfo;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    public boolean update(SourceRequest request, String operator) {
        LOGGER.info("begin to update source info: {}", (Object)request);
        this.checkParams(request);
        Preconditions.checkNotNull((Object)request.getId(), (String)"primary key is empty");
        String groupId = request.getInlongGroupId();
        InlongGroupEntity groupEntity = this.commonOperateService.checkGroupStatus(groupId, operator);
        String sourceType = request.getSourceType();
        StreamSourceOperation operation = this.operationFactory.getInstance(SourceType.forType((String)sourceType));
        operation.updateOpt(request, groupEntity.getStatus(), operator);
        LOGGER.info("success to update source info: {}", (Object)request);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    public boolean updateStatus(String groupId, String streamId, Integer targetStatus, String operator) {
        this.sourceMapper.updateStatusByRelatedId(groupId, streamId, targetStatus);
        LOGGER.info("success to update source status={} for groupId={}, streamId={} by {}", new Object[]{targetStatus, groupId, streamId, operator});
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    public boolean delete(Integer id, String sourceType, String operator) {
        LOGGER.info("begin to delete source by id={}, sourceType={}", (Object)id, (Object)sourceType);
        Preconditions.checkNotNull((Object)id, (String)"primary key is empty");
        StreamSourceEntity entity = this.sourceMapper.selectByIdForUpdate(id);
        Preconditions.checkNotNull((Object)entity, (String)ErrorCodeEnum.SOURCE_INFO_NOT_FOUND.getMessage());
        this.commonOperateService.checkGroupStatus(entity.getInlongGroupId(), operator);
        StreamSourceOperation operation = this.operationFactory.getInstance(SourceType.forType((String)sourceType));
        SourceRequest sourceRequest = new SourceRequest();
        CommonBeanUtils.copyProperties((Object)entity, (Object)sourceRequest, (boolean)true);
        operation.deleteOpt(sourceRequest, operator);
        LOGGER.info("success to delete source info: {}", (Object)entity);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    public boolean restart(Integer id, String sourceType, String operator) {
        LOGGER.info("begin to restart source by id={}, sourceType={}", (Object)id, (Object)sourceType);
        StreamSourceEntity entity = this.sourceMapper.selectByIdForUpdate(id);
        Preconditions.checkNotNull((Object)entity, (String)ErrorCodeEnum.SOURCE_INFO_NOT_FOUND.getMessage());
        this.commonOperateService.checkGroupStatus(entity.getInlongGroupId(), operator);
        StreamSourceOperation operation = this.operationFactory.getInstance(SourceType.forType((String)sourceType));
        SourceRequest sourceRequest = new SourceRequest();
        CommonBeanUtils.copyProperties((Object)entity, (Object)sourceRequest, (boolean)true);
        operation.restartOpt(sourceRequest, operator);
        LOGGER.info("success to restart source info: {}", (Object)entity);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    public boolean stop(Integer id, String sourceType, String operator) {
        LOGGER.info("begin to stop source by id={}, sourceType={}", (Object)id, (Object)sourceType);
        StreamSourceEntity entity = this.sourceMapper.selectByIdForUpdate(id);
        Preconditions.checkNotNull((Object)entity, (String)ErrorCodeEnum.SOURCE_INFO_NOT_FOUND.getMessage());
        this.commonOperateService.checkGroupStatus(entity.getInlongGroupId(), operator);
        StreamSourceOperation operation = this.operationFactory.getInstance(SourceType.forType((String)sourceType));
        SourceRequest sourceRequest = new SourceRequest();
        CommonBeanUtils.copyProperties((Object)entity, (Object)sourceRequest, (boolean)true);
        operation.stopOpt(sourceRequest, operator);
        LOGGER.info("success to stop source info: {}", (Object)entity);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    public boolean logicDeleteAll(String groupId, String streamId, String operator) {
        LOGGER.info("begin to logic delete all source info by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)"inlong group id is empty");
        Preconditions.checkNotNull((Object)streamId, (String)"inlong stream id is empty");
        InlongGroupEntity groupEntity = this.commonOperateService.checkGroupStatus(groupId, operator);
        Integer nextStatus = GroupState.CONFIG_SUCCESSFUL.getCode().equals(groupEntity.getStatus()) ? SourceState.TO_BE_ISSUED_DELETE.getCode() : SourceState.SOURCE_DISABLE.getCode();
        Date now = new Date();
        List entityList = this.sourceMapper.selectByRelatedId(groupId, streamId, null);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            for (StreamSourceEntity entity : entityList) {
                Integer id = entity.getId();
                entity.setVersion(Integer.valueOf(entity.getVersion() + 1));
                entity.setPreviousStatus(entity.getStatus());
                entity.setStatus(nextStatus);
                entity.setIsDeleted(id);
                entity.setModifier(operator);
                entity.setModifyTime(now);
                this.sourceMapper.updateByPrimaryKeySelective(entity);
            }
        }
        LOGGER.info("success to logic delete all source by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    public boolean deleteAll(String groupId, String streamId, String operator) {
        LOGGER.info("begin to delete all source by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        Preconditions.checkNotNull((Object)groupId, (String)"inlong group id is empty");
        Preconditions.checkNotNull((Object)streamId, (String)"inlong stream id is empty");
        this.commonOperateService.checkGroupStatus(groupId, operator);
        this.sourceMapper.deleteByRelatedId(groupId, streamId);
        LOGGER.info("success to delete all source by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        return true;
    }

    @Override
    public List<String> getSourceTypeList(String groupId, String streamId) {
        LOGGER.debug("begin to get source type list by groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        if (StringUtils.isEmpty((CharSequence)streamId)) {
            return Collections.emptyList();
        }
        List resultList = this.sourceMapper.selectSourceType(groupId, streamId);
        LOGGER.debug("success to get source type list, result sourceType={}", (Object)resultList);
        return resultList;
    }

    private void checkParams(SourceRequest request) {
        Preconditions.checkNotNull((Object)request, (String)"request is empty");
        String groupId = request.getInlongGroupId();
        Preconditions.checkNotNull((Object)groupId, (String)"inlong group id is empty");
        String streamId = request.getInlongStreamId();
        Preconditions.checkNotNull((Object)streamId, (String)"inlong stream id is empty");
        String sourceType = request.getSourceType();
        Preconditions.checkNotNull((Object)sourceType, (String)"Source type is empty");
    }
}

