/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source.listener;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.SourceState;
import org.apache.inlong.manager.common.enums.SourceType;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.source.SourceRequest;
import org.apache.inlong.manager.common.pojo.source.SourceResponse;
import org.apache.inlong.manager.common.pojo.source.binlog.BinlogSourceRequest;
import org.apache.inlong.manager.common.pojo.source.binlog.BinlogSourceResponse;
import org.apache.inlong.manager.common.pojo.source.kafka.KafkaSourceRequest;
import org.apache.inlong.manager.common.pojo.source.kafka.KafkaSourceResponse;
import org.apache.inlong.manager.common.pojo.stream.StreamBriefResponse;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.UpdateGroupProcessForm;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.service.core.InlongStreamService;
import org.apache.inlong.manager.service.source.StreamSourceService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.DataSourceOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractSourceOperateListener
implements DataSourceOperateListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractSourceOperateListener.class);
    @Autowired
    protected InlongStreamService streamService;
    @Autowired
    protected StreamSourceService streamSourceService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        log.info("Operate data source for context={}", (Object)context);
        InlongGroupInfo groupInfo = this.getGroupInfo(context.getProcessForm());
        String groupId = groupInfo.getInlongGroupId();
        List<StreamBriefResponse> streamBriefResponses = this.streamService.getBriefList(groupId);
        ArrayList unOperatedSources = Lists.newArrayList();
        streamBriefResponses.forEach(streamBriefResponse -> this.operateStreamSources(groupId, streamBriefResponse.getInlongStreamId(), context.getApplicant(), unOperatedSources));
        if (CollectionUtils.isNotEmpty((Collection)unOperatedSources)) {
            UpdateGroupProcessForm.OperateType operateType = this.getOperateType(context.getProcessForm());
            StringBuilder builder = new StringBuilder("Unsupported operate ").append(operateType).append(" for (");
            unOperatedSources.stream().forEach(source -> builder.append(" ").append(source.getSourceName()).append(" "));
            String errMsg = builder.append(")").toString();
            throw new WorkflowListenerException(errMsg);
        }
        return ListenerResult.success();
    }

    protected void operateStreamSources(String groupId, String streamId, String operator, List<SourceResponse> unOperatedSources) {
        List<SourceResponse> sourceResponses = this.streamSourceService.listSource(groupId, streamId);
        sourceResponses.forEach(sourceResponse -> {
            boolean checkIfOp = this.checkIfOp((SourceResponse)sourceResponse, unOperatedSources);
            if (checkIfOp) {
                SourceRequest sourceRequest = this.createSourceRequest((SourceResponse)sourceResponse);
                this.operateStreamSource(sourceRequest, operator);
            }
        });
    }

    public boolean checkIfOp(SourceResponse sourceResponse, List<SourceResponse> unOperatedSources) {
        for (int retry = 0; retry < 60; ++retry) {
            int status = sourceResponse.getStatus();
            SourceState sourceState = SourceState.forCode((int)status);
            if (sourceState == SourceState.SOURCE_NORMAL || sourceState == SourceState.SOURCE_FROZEN) {
                return true;
            }
            if (sourceState == SourceState.SOURCE_FAILED || sourceState == SourceState.SOURCE_DISABLE) {
                return false;
            }
            log.warn("StreamSource={} cannot be operated for state={}", (Object)sourceResponse, (Object)sourceState);
            TimeUnit.SECONDS.sleep(5L);
            sourceResponse = this.streamSourceService.get(sourceResponse.getId(), sourceResponse.getSourceType());
        }
        SourceState sourceState = SourceState.forCode((int)sourceResponse.getStatus());
        if (sourceState != SourceState.SOURCE_NORMAL && sourceState != SourceState.SOURCE_FROZEN && sourceState != SourceState.SOURCE_DISABLE && sourceState != SourceState.SOURCE_FAILED) {
            log.error("StreamSource={} cannot be operated for state={}", (Object)sourceResponse, (Object)sourceState);
            unOperatedSources.add(sourceResponse);
        }
        return false;
    }

    public SourceRequest createSourceRequest(SourceResponse sourceResponse) {
        String sourceType = sourceResponse.getSourceType();
        SourceType type = SourceType.valueOf((String)sourceType);
        switch (type) {
            case BINLOG: {
                return (SourceRequest)CommonBeanUtils.copyProperties((Object)((BinlogSourceResponse)sourceResponse), BinlogSourceRequest::new);
            }
            case KAFKA: {
                return (SourceRequest)CommonBeanUtils.copyProperties((Object)((KafkaSourceResponse)sourceResponse), KafkaSourceRequest::new);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported type=%s for DataSourceOperateListener", type));
    }

    public abstract void operateStreamSource(SourceRequest var1, String var2);

    private UpdateGroupProcessForm.OperateType getOperateType(ProcessForm processForm) {
        if (processForm instanceof GroupResourceProcessForm) {
            return UpdateGroupProcessForm.OperateType.INIT;
        }
        if (processForm instanceof UpdateGroupProcessForm) {
            UpdateGroupProcessForm updateGroupProcessForm = (UpdateGroupProcessForm)processForm;
            return updateGroupProcessForm.getOperateType();
        }
        log.error("Illegal ProcessForm {} to get inlong group info", (Object)processForm.getFormName());
        throw new RuntimeException(String.format("Unsupported ProcessForm {%s} in CreateSortConfigListener", processForm.getFormName()));
    }

    private InlongGroupInfo getGroupInfo(ProcessForm processForm) {
        if (processForm instanceof GroupResourceProcessForm) {
            GroupResourceProcessForm groupResourceProcessForm = (GroupResourceProcessForm)processForm;
            return groupResourceProcessForm.getGroupInfo();
        }
        if (processForm instanceof UpdateGroupProcessForm) {
            UpdateGroupProcessForm updateGroupProcessForm = (UpdateGroupProcessForm)processForm;
            return updateGroupProcessForm.getGroupInfo();
        }
        log.error("Illegal ProcessForm {} to get inlong group info", (Object)processForm.getFormName());
        throw new RuntimeException(String.format("Unsupported ProcessForm {%s} in CreateSortConfigListener", processForm.getFormName()));
    }

    public boolean async() {
        return false;
    }
}

