/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.elasticsearch;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ElasticsearchConfig {
    @Value(value="${es.index.search.hostname}")
    private String host;
    @Value(value="${es.index.search.port}")
    private Integer port = 9200;
    @Value(value="${es.auth.enable}")
    private Boolean authEnable = false;
    @Value(value="${es.auth.user}")
    private String user;
    @Value(value="${es.auth.password}")
    private String password;
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchConfig.class);
    private static RestHighLevelClient highLevelClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestHighLevelClient highLevelClient() {
        if (highLevelClient != null) {
            return highLevelClient;
        }
        try {
            Class<RestHighLevelClient> clazz = RestHighLevelClient.class;
            synchronized (RestHighLevelClient.class) {
                if (highLevelClient == null) {
                    String[] hostArrays;
                    ArrayList<HttpHost> hosts = new ArrayList<HttpHost>();
                    for (String host : hostArrays = this.host.split(",")) {
                        if (!StringUtils.isNotBlank((String)host)) continue;
                        host = host.trim();
                        hosts.add(new HttpHost(host, this.port.intValue(), "http"));
                    }
                    RestClientBuilder clientBuilder = RestClient.builder((HttpHost[])hosts.toArray(new HttpHost[0]));
                    this.setEsAuth(clientBuilder);
                    highLevelClient = new RestHighLevelClient(clientBuilder);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            logger.error("get es high level client error", (Throwable)e);
        }
        {
            return highLevelClient;
        }
    }

    private void setEsAuth(RestClientBuilder builder) {
        try {
            logger.info("set es auth of enable={}", (Object)this.authEnable);
            if (this.authEnable.booleanValue()) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.user, this.password));
                builder.setHttpClientConfigCallback(arg_0 -> ElasticsearchConfig.lambda$setEsAuth$0((CredentialsProvider)credentialsProvider, arg_0));
            }
        }
        catch (Exception e) {
            logger.error("set es auth error ", (Throwable)e);
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$setEsAuth$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

