/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.hive;

import java.util.List;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.dao.mapper.StreamSinkEntityMapper;
import org.apache.inlong.manager.service.thirdparty.hive.DefaultHiveTableOperator;
import org.apache.inlong.manager.service.thirdparty.hive.IHiveTableOperator;
import org.apache.inlong.manager.service.utils.SpringContextUtils;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SinkOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateHiveSinkForStreamListener
implements SinkOperateListener {
    private static final Logger log = LoggerFactory.getLogger(CreateHiveSinkForStreamListener.class);
    @Autowired
    private StreamSinkEntityMapper sinkMapper;
    private IHiveTableOperator hiveTableOperator;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        String streamId = form.getInlongStreamId();
        log.info("begin create hive table for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        List configList = this.sinkMapper.selectAllConfig(groupId, streamId);
        if (this.hiveTableOperator == null) {
            this.hiveTableOperator = (IHiveTableOperator)SpringContextUtils.getBean("HiveTableOperator", DefaultHiveTableOperator.class.getName());
        }
        this.hiveTableOperator.createHiveResource(groupId, configList);
        String result = "success to create hive table for group [" + groupId + "], stream [" + streamId + "]";
        log.info(result);
        return ListenerResult.success((String)result);
    }

    public boolean async() {
        return false;
    }
}

