/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.hive;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.dao.entity.InlongStreamEntity;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.EventSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HiveSinkEventSelector
implements EventSelector {
    private static final Logger log = LoggerFactory.getLogger(HiveSinkEventSelector.class);
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private InlongStreamEntityMapper streamMapper;

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        if (!(processForm instanceof GroupResourceProcessForm)) {
            return false;
        }
        GroupResourceProcessForm form = (GroupResourceProcessForm)processForm;
        String groupId = form.getInlongGroupId();
        if (form.getGroupInfo() == null || StringUtils.isEmpty((CharSequence)form.getGroupInfo().getInlongGroupId())) {
            log.info("not add create hive table listener as the info was null for groupId [{}]", (Object)groupId);
            return false;
        }
        List<String> streamWithHiveSink = this.sinkService.getExistsStreamIdList(groupId, "HIVE", this.streamMapper.selectByGroupId(groupId).stream().map(InlongStreamEntity::getInlongStreamId).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(streamWithHiveSink)) {
            log.warn("skip to create hive table as no hive sink found for groupId={} streamId={}", (Object)groupId, (Object)form.getInlongStreamId());
            return false;
        }
        log.info("add create hive table listener for groupId [{}]", (Object)groupId);
        return true;
    }
}

