/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.hive.builder;

import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.pojo.query.hive.HiveColumnQueryBean;
import org.apache.inlong.manager.common.pojo.query.hive.HiveTableQueryBean;
import org.apache.inlong.manager.service.thirdparty.hive.builder.SqlBuilder;

public class HiveChangeColumnBuilder
extends SqlBuilder<HiveTableQueryBean> {
    @Override
    public String buildDDL(HiveTableQueryBean table) {
        String dbTableName = "`" + table.getDbName() + "." + table.getTableName() + "`";
        if (table.getColumns() == null || table.getColumns().size() == 0) {
            return null;
        }
        this.ddl.append("ALTER TABLE ").append(dbTableName).append(" CHANGE COLUMN ");
        HiveColumnQueryBean column = (HiveColumnQueryBean)table.getColumns().get(0);
        String oldColumnName = "`" + column.getOldColumnName() + "`";
        String columnName = "`" + column.getColumnName() + "`";
        this.ddl.append(oldColumnName).append(" ").append(columnName).append(" ").append(column.getColumnType());
        if (StringUtils.isNotEmpty((CharSequence)column.getColumnDesc())) {
            this.ddl.append(" COMMENT ").append("'").append(column.getColumnDesc()).append("'");
        }
        return this.ddl.toString();
    }

    @Override
    public String getOPT() {
        return null;
    }
}

