/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.hive.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.pojo.query.hive.HiveColumnQueryBean;
import org.apache.inlong.manager.common.pojo.query.hive.HiveTableQueryBean;
import org.apache.inlong.manager.service.thirdparty.hive.builder.SqlBuilder;

public class HiveTableCreateSqlBuilder
extends SqlBuilder<HiveTableQueryBean> {
    @Override
    public String buildDDL(HiveTableQueryBean table) {
        String dbTableName = "`" + table.getDbName() + "." + table.getTableName() + "`";
        this.ddl.append("CREATE TABLE ").append(dbTableName);
        this.ddl.append(this.buildColumnsAndComments(table.getColumns(), table.getTableDesc()));
        if (table.getFieldTerSymbol() != null) {
            this.ddl.append(" ROW FORMAT DELIMITED FIELDS TERMINATED BY '").append(table.getFieldTerSymbol()).append("'");
        }
        return this.ddl.toString();
    }

    private String buildColumnsAndComments(List<HiveColumnQueryBean> columns, String tableComment) {
        ArrayList<String> columnInfoList = new ArrayList<String>();
        ArrayList<String> partitionList = new ArrayList<String>();
        for (HiveColumnQueryBean columnBean : columns) {
            String columnName = "`" + columnBean.getColumnName() + "`";
            StringBuilder columnInfo = new StringBuilder().append(columnName).append(" ").append(columnBean.getColumnType());
            if (StringUtils.isNotEmpty((CharSequence)columnBean.getColumnDesc())) {
                columnInfo.append(" COMMENT ").append("'").append(columnBean.getColumnDesc()).append("'");
            }
            if (columnBean.isPartition()) {
                partitionList.add(columnInfo.toString());
                continue;
            }
            columnInfoList.add(columnInfo.toString());
        }
        StringBuilder result = new StringBuilder().append(" (").append(StringUtils.join(columnInfoList, (String)",")).append(") ");
        if (StringUtils.isNotEmpty((CharSequence)tableComment)) {
            result.append("COMMENT ").append("'").append(tableComment).append("' ");
        }
        if (partitionList.size() > 0) {
            result.append("PARTITIONED BY (").append(StringUtils.join(partitionList, (String)",")).append(") ");
        }
        return result.toString();
    }

    @Override
    public String getOPT() {
        return "CREATE_TABLE_HIVE";
    }
}

