/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.mq;

import java.util.List;
import org.apache.inlong.common.pojo.dataproxy.PulsarClusterInfo;
import org.apache.inlong.manager.common.beans.ClusterBean;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.pulsar.PulsarTopicBean;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.dao.entity.InlongStreamEntity;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.apache.inlong.manager.service.CommonOperateService;
import org.apache.inlong.manager.service.core.ConsumptionService;
import org.apache.inlong.manager.service.core.InlongGroupService;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.apache.inlong.manager.service.thirdparty.mq.PulsarOptService;
import org.apache.inlong.manager.service.thirdparty.mq.util.PulsarUtils;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.QueueOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreatePulsarGroupForStreamTaskListener
implements QueueOperateListener {
    private static final Logger log = LoggerFactory.getLogger(CreatePulsarGroupForStreamTaskListener.class);
    @Autowired
    private CommonOperateService commonOperateService;
    @Autowired
    private ClusterBean clusterBean;
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongStreamEntityMapper streamMapper;
    @Autowired
    private PulsarOptService pulsarOptService;
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private ConsumptionService consumptionService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        String streamId = form.getInlongStreamId();
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        if (groupInfo == null) {
            log.error("inlong group not found with groupId={}", (Object)groupId);
            throw new WorkflowListenerException("inlong group not found with groupId=" + groupId);
        }
        InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (streamEntity == null) {
            log.warn("inlong stream is empty for group={}, stream={}, skip to create pulsar group", (Object)groupId, (Object)streamId);
            return ListenerResult.success();
        }
        PulsarClusterInfo globalCluster = this.commonOperateService.getPulsarClusterInfo(groupInfo.getMiddlewareType());
        try (PulsarAdmin globalPulsarAdmin = PulsarUtils.getPulsarAdmin(globalCluster);){
            List<String> sinkTypeList = this.sinkService.getSinkTypeList(groupId, streamId);
            if (sinkTypeList == null || sinkTypeList.size() == 0) {
                log.warn("sink info is empty for groupId={}, streamId={}, skip to create pulsar group", (Object)groupId, (Object)streamId);
                ListenerResult listenerResult = ListenerResult.success();
                return listenerResult;
            }
            PulsarTopicBean topicBean = new PulsarTopicBean();
            topicBean.setTenant(this.clusterBean.getDefaultTenant());
            topicBean.setNamespace(groupInfo.getMqResourceObj());
            String topic = streamEntity.getMqResourceObj();
            topicBean.setTopicName(topic);
            List<String> pulsarClusters = PulsarUtils.getPulsarClusters(globalPulsarAdmin);
            String tenant = this.clusterBean.getDefaultTenant();
            String namespace = groupInfo.getMqResourceObj();
            for (String cluster : pulsarClusters) {
                String serviceUrl = PulsarUtils.getServiceUrl(globalPulsarAdmin, cluster);
                PulsarClusterInfo pulsarClusterInfo = PulsarClusterInfo.builder().token(globalCluster.getToken()).adminUrl(serviceUrl).build();
                PulsarAdmin pulsarAdmin = PulsarUtils.getPulsarAdmin(pulsarClusterInfo);
                Throwable throwable = null;
                try {
                    boolean exist = this.pulsarOptService.topicIsExists(pulsarAdmin, tenant, namespace, topic);
                    if (!exist) {
                        String fullTopic = tenant + "/" + namespace + "/" + topic;
                        log.error("topic={} not exists in {}", (Object)fullTopic, (Object)pulsarAdmin.getServiceUrl());
                        throw new BusinessException("topic=" + fullTopic + " not exists in " + serviceUrl);
                    }
                    String subscription = this.clusterBean.getAppName() + "_" + topic + "_consumer_group";
                    this.pulsarOptService.createSubscription(pulsarAdmin, topicBean, subscription);
                    this.consumptionService.saveSortConsumption(groupInfo, topic, subscription);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pulsarAdmin == null) continue;
                    if (throwable != null) {
                        try {
                            pulsarAdmin.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pulsarAdmin.close();
                }
            }
        }
        catch (Exception e) {
            log.error("create pulsar subscription error for groupId={}, streamId={}", new Object[]{groupId, streamId, e});
            throw new WorkflowListenerException("create pulsar subscription error, reason: " + e.getMessage());
        }
        log.info("finish to create single pulsar subscription for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

