/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.mq;

import java.util.List;
import org.apache.inlong.common.pojo.dataproxy.PulsarClusterInfo;
import org.apache.inlong.manager.common.beans.ClusterBean;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.pulsar.PulsarTopicBean;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamTopicResponse;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongGroupPulsarEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupPulsarEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.apache.inlong.manager.service.CommonOperateService;
import org.apache.inlong.manager.service.core.InlongGroupService;
import org.apache.inlong.manager.service.thirdparty.mq.PulsarOptService;
import org.apache.inlong.manager.service.thirdparty.mq.util.PulsarUtils;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.QueueOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreatePulsarResourceTaskListener
implements QueueOperateListener {
    private static final Logger log = LoggerFactory.getLogger(CreatePulsarResourceTaskListener.class);
    @Autowired
    PulsarOptService pulsarOptService;
    @Autowired
    private ClusterBean clusterBean;
    @Autowired
    private CommonOperateService commonOperateService;
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongGroupPulsarEntityMapper groupPulsarMapper;
    @Autowired
    private InlongStreamEntityMapper streamMapper;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        log.info("begin to create pulsar resource for groupId={}", (Object)groupId);
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        if (groupInfo == null) {
            throw new WorkflowListenerException("inlong group or pulsar cluster not found for groupId=" + groupId);
        }
        PulsarClusterInfo globalCluster = this.commonOperateService.getPulsarClusterInfo(groupInfo.getMiddlewareType());
        try (PulsarAdmin globalPulsarAdmin = PulsarUtils.getPulsarAdmin(globalCluster);){
            List<String> pulsarClusters = PulsarUtils.getPulsarClusters(globalPulsarAdmin);
            for (String cluster : pulsarClusters) {
                String serviceUrl = PulsarUtils.getServiceUrl(globalPulsarAdmin, cluster);
                PulsarClusterInfo pulsarClusterInfo = PulsarClusterInfo.builder().token(globalCluster.getToken()).adminUrl(serviceUrl).build();
                this.createPulsarProcess(groupInfo, pulsarClusterInfo);
            }
        }
        catch (Exception e) {
            log.error("create pulsar resource error for groupId={}", (Object)groupId, (Object)e);
            throw new WorkflowListenerException("create pulsar resource error for groupId=" + groupId);
        }
        log.info("success to create pulsar resource for groupId={}", (Object)groupId);
        return ListenerResult.success();
    }

    private void createPulsarProcess(InlongGroupInfo groupInfo, PulsarClusterInfo pulsarClusterInfo) throws Exception {
        String groupId = groupInfo.getInlongGroupId();
        log.info("begin to create pulsar resource for groupId={} in cluster={}", (Object)groupId, (Object)pulsarClusterInfo);
        String namespace = groupInfo.getMqResourceObj();
        Preconditions.checkNotNull((Object)namespace, (String)("pulsar namespace cannot be empty for groupId=" + groupId));
        String queueModule = groupInfo.getQueueModule();
        Preconditions.checkNotNull((Object)queueModule, (String)("queue module cannot be empty for groupId=" + groupId));
        String tenant = this.clusterBean.getDefaultTenant();
        try (PulsarAdmin pulsarAdmin = PulsarUtils.getPulsarAdmin(pulsarClusterInfo);){
            this.pulsarOptService.createTenant(pulsarAdmin, tenant);
            InlongGroupPulsarEntity entity = this.groupPulsarMapper.selectByGroupId(groupId);
            this.pulsarOptService.createNamespace(pulsarAdmin, entity, tenant, namespace);
            Integer partitionNum = groupInfo.getTopicPartitionNum();
            List streamTopicList = this.streamMapper.selectTopicList(groupId);
            PulsarTopicBean topicBean = PulsarTopicBean.builder().tenant(tenant).namespace(namespace).numPartitions(partitionNum).queueModule(queueModule).build();
            for (InlongStreamTopicResponse topicVO : streamTopicList) {
                topicBean.setTopicName(topicVO.getMqResourceObj());
                this.pulsarOptService.createTopic(pulsarAdmin, topicBean);
            }
        }
        log.info("finish to create pulsar resource for groupId={}, service http url={}", (Object)groupId, (Object)pulsarClusterInfo.getAdminUrl());
    }

    public boolean async() {
        return false;
    }
}

