/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.mq;

import java.util.Collections;
import org.apache.inlong.manager.common.beans.ReTryConfigBean;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.tubemq.AddTubeConsumeGroupRequest;
import org.apache.inlong.manager.common.pojo.tubemq.QueryTubeTopicRequest;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.service.CommonOperateService;
import org.apache.inlong.manager.service.core.InlongGroupService;
import org.apache.inlong.manager.service.thirdparty.mq.TubeMqOptService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.QueueOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateTubeGroupTaskListener
implements QueueOperateListener {
    private static final Logger log = LoggerFactory.getLogger(CreateTubeGroupTaskListener.class);
    @Autowired
    InlongGroupService groupService;
    @Autowired
    TubeMqOptService tubeMqOptService;
    @Autowired
    ReTryConfigBean reTryConfigBean;
    @Autowired
    private CommonOperateService commonOperateService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        log.info("try to create consumer group for groupId {}", (Object)groupId);
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        String topicName = groupInfo.getMqResourceObj();
        int clusterId = Integer.parseInt(this.commonOperateService.getSpecifiedParam("cluster_tube_clusterId"));
        QueryTubeTopicRequest queryTubeTopicRequest = QueryTubeTopicRequest.builder().topicName(topicName).clusterId(Integer.valueOf(clusterId)).user(groupInfo.getCreator()).build();
        boolean topicExist = this.tubeMqOptService.queryTopicIsExist(queryTubeTopicRequest);
        Integer tryNumber = this.reTryConfigBean.getMaxAttempts();
        Long delay = this.reTryConfigBean.getDelay();
        while (!topicExist && (tryNumber = Integer.valueOf(tryNumber - 1)) > 0) {
            log.info("check whether the tube topic exists, try count={}", (Object)tryNumber);
            try {
                Thread.sleep(delay);
                delay = delay * (long)this.reTryConfigBean.getMultiplier().intValue();
                topicExist = this.tubeMqOptService.queryTopicIsExist(queryTubeTopicRequest);
            }
            catch (InterruptedException e) {
                log.error("check the tube topic exists error", (Throwable)e);
            }
        }
        AddTubeConsumeGroupRequest addTubeConsumeGroupRequest = new AddTubeConsumeGroupRequest();
        addTubeConsumeGroupRequest.setClusterId(clusterId);
        addTubeConsumeGroupRequest.setCreateUser(groupInfo.getCreator());
        AddTubeConsumeGroupRequest.GroupNameJsonSetBean groupNameJsonSetBean = new AddTubeConsumeGroupRequest.GroupNameJsonSetBean();
        groupNameJsonSetBean.setTopicName(topicName);
        String consumeGroupName = "sort_" + topicName + "_group";
        groupNameJsonSetBean.setGroupName(consumeGroupName);
        addTubeConsumeGroupRequest.setGroupNameJsonSet(Collections.singletonList(groupNameJsonSetBean));
        try {
            this.tubeMqOptService.createNewConsumerGroup(addTubeConsumeGroupRequest);
        }
        catch (Exception e) {
            throw new WorkflowListenerException("create tube consumer group for groupId=" + groupId + " error", (Throwable)e);
        }
        log.info("finish to create consumer group for {}", (Object)groupId);
        return ListenerResult.success();
    }

    public boolean async() {
        return true;
    }
}

