/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.mq;

import java.util.Collections;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.tubemq.AddTubeMqTopicRequest;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.service.core.InlongGroupService;
import org.apache.inlong.manager.service.thirdparty.mq.TubeMqOptService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.QueueOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateTubeTopicTaskListener
implements QueueOperateListener {
    private static final Logger log = LoggerFactory.getLogger(CreateTubeTopicTaskListener.class);
    @Autowired
    private TubeMqOptService tubeMqOptService;
    @Autowired
    private InlongGroupService groupService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        log.info("begin create tube topic for groupId={}", (Object)form.getInlongGroupId());
        String groupId = form.getInlongGroupId();
        try {
            InlongGroupInfo groupInfo = this.groupService.get(groupId);
            String topicName = groupInfo.getMqResourceObj();
            AddTubeMqTopicRequest request = new AddTubeMqTopicRequest();
            request.setUser("inlong-manager");
            AddTubeMqTopicRequest.AddTopicTasksBean tasksBean = new AddTubeMqTopicRequest.AddTopicTasksBean();
            tasksBean.setTopicName(topicName);
            request.setAddTopicTasks(Collections.singletonList(tasksBean));
            this.tubeMqOptService.createNewTopic(request);
            log.info("finish to create tube topic for groupId={}", (Object)groupId);
        }
        catch (Exception e) {
            log.error("create tube topic for groupId={} error, exception {} ", new Object[]{groupId, e.getMessage(), e});
        }
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

