/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.mq;

import org.apache.inlong.manager.common.enums.MQType;
import org.apache.inlong.manager.common.pojo.group.InlongGroupPulsarInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.EventSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarEventSelector
implements EventSelector {
    private static final Logger log = LoggerFactory.getLogger(PulsarEventSelector.class);

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        if (!(processForm instanceof GroupResourceProcessForm)) {
            return false;
        }
        GroupResourceProcessForm form = (GroupResourceProcessForm)processForm;
        String groupId = form.getInlongGroupId();
        MQType mqType = MQType.forType((String)form.getGroupInfo().getMiddlewareType());
        if (mqType == MQType.PULSAR || mqType == MQType.TDMQ_PULSAR) {
            boolean enable;
            InlongGroupPulsarInfo pulsarInfo = (InlongGroupPulsarInfo)form.getGroupInfo().getMqExtInfo();
            boolean bl = enable = pulsarInfo.getEnableCreateResource() == 1;
            if (enable) {
                log.info("need to create pulsar resource as the createResource was true for groupId [{}]", (Object)groupId);
                return true;
            }
            log.info("skip to create pulsar resource as the createResource was false for groupId [{}]", (Object)groupId);
            return false;
        }
        log.warn("skip to create pulsar subscription as the mq type is {} for groupId [{}]", (Object)mqType, (Object)groupId);
        return false;
    }
}

