/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.mq;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collection;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.tubemq.AddTubeConsumeGroupRequest;
import org.apache.inlong.manager.common.pojo.tubemq.AddTubeMqTopicRequest;
import org.apache.inlong.manager.common.pojo.tubemq.QueryTubeTopicRequest;
import org.apache.inlong.manager.common.pojo.tubemq.TubeManagerResponse;
import org.apache.inlong.manager.common.util.HttpUtils;
import org.apache.inlong.manager.service.CommonOperateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TubeMqOptService {
    private static final Logger log = LoggerFactory.getLogger(TubeMqOptService.class);
    private static final Gson GSON = new GsonBuilder().create();
    @Autowired
    private CommonOperateService commonOperateService;
    @Autowired
    private HttpUtils httpUtils;

    public String createNewTopic(AddTubeMqTopicRequest request) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", "application/json");
        try {
            if (CollectionUtils.isEmpty((Collection)request.getAddTopicTasks())) {
                throw new Exception("topic cannot be empty");
            }
            AddTubeMqTopicRequest.AddTopicTasksBean addTopicTasksBean = (AddTubeMqTopicRequest.AddTopicTasksBean)request.getAddTopicTasks().get(0);
            String clusterIdStr = this.commonOperateService.getSpecifiedParam("cluster_tube_clusterId");
            int clusterId = Integer.parseInt(clusterIdStr);
            QueryTubeTopicRequest topicRequest = QueryTubeTopicRequest.builder().topicName(addTopicTasksBean.getTopicName()).clusterId(Integer.valueOf(clusterId)).user(request.getUser()).build();
            String tubeManager = this.commonOperateService.getSpecifiedParam("cluster_tube_manager");
            TubeManagerResponse response = (TubeManagerResponse)this.httpUtils.request(tubeManager + "/v1/topic?method=queryCanWrite", HttpMethod.POST, GSON.toJson((Object)topicRequest), httpHeaders, TubeManagerResponse.class);
            if (response.getErrCode() == 101) {
                log.info(" create tube topic  {}  on {} ", (Object)GSON.toJson((Object)request), (Object)(tubeManager + "/v1/task?method=addTopicTask"));
                request.setClusterId(Integer.valueOf(clusterId));
                TubeManagerResponse tubeManagerResponse = (TubeManagerResponse)this.httpUtils.request(tubeManager + "/v1/task?method=addTopicTask", HttpMethod.POST, GSON.toJson((Object)request), httpHeaders, TubeManagerResponse.class);
            } else {
                log.warn("topic {} exists in {} ", (Object)addTopicTasksBean.getTopicName(), (Object)tubeManager);
            }
        }
        catch (Exception e) {
            log.error("fail to create tube topic " + ((AddTubeMqTopicRequest.AddTopicTasksBean)request.getAddTopicTasks().get(0)).getTopicName(), (Throwable)e);
        }
        return "";
    }

    public String createNewConsumerGroup(AddTubeConsumeGroupRequest request) throws Exception {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", "application/json");
        try {
            String tubeManager = this.commonOperateService.getSpecifiedParam("cluster_tube_manager");
            log.info("create tube consumer group {}  on {} ", (Object)GSON.toJson((Object)request), (Object)(tubeManager + "/v1/task?method=addTopicTask"));
            TubeManagerResponse rsp = (TubeManagerResponse)this.httpUtils.request(tubeManager + "/v1/group?method=add", HttpMethod.POST, GSON.toJson((Object)request), httpHeaders, TubeManagerResponse.class);
            if (rsp.getErrCode() == -1) {
                throw new BusinessException(ErrorCodeEnum.CONSUMER_GROUP_CREATE_FAILED, rsp.getErrMsg());
            }
        }
        catch (BusinessException e) {
            log.error(" fail to create tube consumer group  " + GSON.toJson((Object)request), (Throwable)e);
            throw e;
        }
        return "";
    }

    public boolean queryTopicIsExist(QueryTubeTopicRequest queryTubeTopicRequest) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", "application/json");
        try {
            String tubeManager = this.commonOperateService.getSpecifiedParam("cluster_tube_manager");
            TubeManagerResponse response = (TubeManagerResponse)this.httpUtils.request(tubeManager + "/v1/topic?method=queryCanWrite", HttpMethod.POST, GSON.toJson((Object)queryTubeTopicRequest), httpHeaders, TubeManagerResponse.class);
            if (response.getErrCode() == 0) {
                log.error("topic {} exists in {} ", (Object)queryTubeTopicRequest.getTopicName(), (Object)tubeManager);
                return true;
            }
        }
        catch (Exception e) {
            log.error("fail to query tube topic {}", (Object)queryTubeTopicRequest.getTopicName(), (Object)e);
        }
        return false;
    }
}

