/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.mq.util;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.pojo.dataproxy.PulsarClusterInfo;
import org.apache.inlong.manager.common.settings.InlongGroupSettings;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarUtils {
    private static final Logger log = LoggerFactory.getLogger(PulsarUtils.class);

    private PulsarUtils() {
    }

    public static PulsarAdmin getPulsarAdmin(PulsarClusterInfo pulsarClusterInfo) throws PulsarClientException {
        Preconditions.checkNotNull((Object)pulsarClusterInfo.getAdminUrl(), (String)"pulsar adminUrl is empty, check third party cluster table");
        PulsarAdmin pulsarAdmin = StringUtils.isEmpty((CharSequence)pulsarClusterInfo.getToken()) ? PulsarUtils.getPulsarAdmin(pulsarClusterInfo.getAdminUrl()) : PulsarUtils.getPulsarAdmin(pulsarClusterInfo.getAdminUrl(), pulsarClusterInfo.getToken(), InlongGroupSettings.DEFAULT_PULSAR_AUTHENTICATION_TYPE);
        return pulsarAdmin;
    }

    public static PulsarAdmin getPulsarAdmin(String serviceHttpUrl) throws PulsarClientException {
        return PulsarAdmin.builder().serviceHttpUrl(serviceHttpUrl).build();
    }

    private static PulsarAdmin getPulsarAdmin(String serviceHttpUrl, String authentication, String authenticationType) throws PulsarClientException {
        if (InlongGroupSettings.DEFAULT_PULSAR_AUTHENTICATION_TYPE.equals(authenticationType)) {
            return PulsarAdmin.builder().serviceHttpUrl(serviceHttpUrl).authentication(AuthenticationFactory.token((String)authentication)).build();
        }
        throw new IllegalArgumentException(String.format("illegal authentication type for pulsar : %s", authenticationType));
    }

    public static List<String> getPulsarClusters(PulsarAdmin pulsarAdmin) throws PulsarAdminException {
        return pulsarAdmin.clusters().getClusters();
    }

    public static String getServiceUrl(PulsarAdmin pulsarAdmin, String pulsarCluster) throws PulsarAdminException {
        return pulsarAdmin.clusters().getCluster(pulsarCluster).getServiceUrl();
    }
}

