/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.sort;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupExtInfo;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.sink.SinkResponse;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.UpdateGroupProcessForm;
import org.apache.inlong.manager.common.settings.InlongGroupSettings;
import org.apache.inlong.manager.service.CommonOperateService;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.apache.inlong.sort.protocol.DataFlowInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateSortConfigListener
implements SortOperateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateSortConfigListener.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Autowired
    private CommonOperateService commonOperateService;
    @Autowired
    private StreamSinkService streamSinkService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        UpdateGroupProcessForm updateGroupProcessForm;
        UpdateGroupProcessForm.OperateType operateType;
        LOGGER.info("Create sort config for context={}", (Object)context);
        ProcessForm form = context.getProcessForm();
        if (form instanceof UpdateGroupProcessForm && ((operateType = (updateGroupProcessForm = (UpdateGroupProcessForm)form).getOperateType()) == UpdateGroupProcessForm.OperateType.SUSPEND || operateType == UpdateGroupProcessForm.OperateType.DELETE)) {
            return ListenerResult.success();
        }
        InlongGroupInfo groupInfo = this.getGroupInfo(form);
        String groupId = groupInfo.getInlongGroupId();
        if (StringUtils.isEmpty((CharSequence)groupId)) {
            LOGGER.warn("GroupId is null for context={}", (Object)context);
            return ListenerResult.success();
        }
        List<SinkResponse> sinkResponseList = this.streamSinkService.listSink(groupId, null);
        if (CollectionUtils.isEmpty(sinkResponseList)) {
            LOGGER.warn("Sink not found by groupId={}", (Object)groupId);
            return ListenerResult.success();
        }
        try {
            Map<String, DataFlowInfo> dataFlowInfoMap = sinkResponseList.stream().map(sink -> {
                DataFlowInfo flowInfo = this.commonOperateService.createDataFlow(groupInfo, (SinkResponse)sink);
                return Pair.of((Object)sink.getInlongStreamId(), (Object)flowInfo);
            }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            String dataFlows = OBJECT_MAPPER.writeValueAsString(dataFlowInfoMap);
            InlongGroupExtInfo extInfo = new InlongGroupExtInfo();
            extInfo.setInlongGroupId(groupId);
            extInfo.setKeyName(InlongGroupSettings.DATA_FLOW);
            extInfo.setKeyValue(dataFlows);
            if (groupInfo.getExtList() == null) {
                groupInfo.setExtList((List)Lists.newArrayList());
            }
            this.upsertDataFlow(groupInfo, extInfo);
        }
        catch (Exception e) {
            LOGGER.error("create sort config failed for sink list={} ", sinkResponseList, (Object)e);
            throw new WorkflowListenerException("create sort config failed: " + e.getMessage());
        }
        return ListenerResult.success();
    }

    private void upsertDataFlow(InlongGroupInfo groupInfo, InlongGroupExtInfo extInfo) {
        groupInfo.getExtList().removeIf(ext -> InlongGroupSettings.DATA_FLOW.equals(ext.getKeyName()));
        groupInfo.getExtList().add(extInfo);
    }

    private InlongGroupInfo getGroupInfo(ProcessForm processForm) {
        if (processForm instanceof GroupResourceProcessForm) {
            GroupResourceProcessForm groupResourceProcessForm = (GroupResourceProcessForm)processForm;
            return groupResourceProcessForm.getGroupInfo();
        }
        if (processForm instanceof UpdateGroupProcessForm) {
            UpdateGroupProcessForm updateGroupProcessForm = (UpdateGroupProcessForm)processForm;
            return updateGroupProcessForm.getGroupInfo();
        }
        LOGGER.error("Illegal ProcessForm {} to get inlong group info", (Object)processForm.getFormName());
        throw new WorkflowListenerException(String.format("Unsupported ProcessForm {%s}", processForm.getFormName()));
    }

    public boolean async() {
        return false;
    }
}

