/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.sort;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.beans.ClusterBean;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.sink.SinkResponse;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.service.CommonOperateService;
import org.apache.inlong.manager.service.core.InlongGroupService;
import org.apache.inlong.manager.service.core.InlongStreamService;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.apache.inlong.sort.ZkTools;
import org.apache.inlong.sort.protocol.DataFlowInfo;
import org.apache.inlong.sort.protocol.deserialization.InLongMsgCsvDeserializationInfo;
import org.apache.inlong.sort.protocol.source.SourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PushSortConfigListener
implements SortOperateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushSortConfigListener.class);
    @Autowired
    private CommonOperateService commonOperateService;
    @Autowired
    private ClusterBean clusterBean;
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongStreamService streamService;
    @Autowired
    private StreamSinkService streamSinkService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("begin to push sort config by context={}", (Object)context);
        }
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getGroupInfo().getInlongGroupId();
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        String streamId = form.getInlongStreamId();
        List<SinkResponse> sinkResponseList = this.streamSinkService.listSink(groupId, streamId);
        if (CollectionUtils.isEmpty(sinkResponseList)) {
            LOGGER.warn("Sink not found by groupId={}", (Object)groupId);
            return ListenerResult.success();
        }
        for (SinkResponse sinkResponse : sinkResponseList) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("sink info: {}", (Object)sinkResponse);
            }
            DataFlowInfo dataFlowInfo = this.commonOperateService.createDataFlow(groupInfo, sinkResponse);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("try to push config to sort: {}", (Object)JsonUtils.toJson((Object)dataFlowInfo));
            }
            Integer sinkId = sinkResponse.getId();
            try {
                String zkUrl = this.clusterBean.getZkUrl();
                String zkRoot = this.clusterBean.getZkRoot();
                String sortClusterName = this.clusterBean.getAppName();
                ZkTools.updateDataFlowInfo((DataFlowInfo)dataFlowInfo, (String)sortClusterName, (long)sinkId.intValue(), (String)zkUrl, (String)zkRoot);
                ZkTools.addDataFlowToCluster((String)sortClusterName, (long)sinkId.intValue(), (String)zkUrl, (String)zkRoot);
            }
            catch (Exception e) {
                LOGGER.error("push sort config to zookeeper failed, sinkId={} ", (Object)sinkId, (Object)e);
                throw new WorkflowListenerException("push sort config to zookeeper failed: " + e.getMessage());
            }
        }
        return ListenerResult.success();
    }

    @Deprecated
    private SourceInfo getSourceInfo(InlongGroupInfo groupInfo, String streamId, List<StreamSinkFieldEntity> fieldList) {
        String dataType;
        InLongMsgCsvDeserializationInfo deserializationInfo = null;
        String groupId = groupInfo.getInlongGroupId();
        InlongStreamInfo streamInfo = this.streamService.get(groupId, streamId);
        boolean isDbType = "DB".equals(streamInfo.getDataType());
        if (!isDbType && ("TEXT".equalsIgnoreCase(dataType = streamInfo.getDataType()) || "KEY-VALUE".equalsIgnoreCase(dataType))) {
            char separator = (char)Integer.parseInt(streamInfo.getDataSeparator());
            deserializationInfo = new InLongMsgCsvDeserializationInfo(streamId, separator);
        }
        return null;
    }

    public boolean async() {
        return false;
    }
}

