/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.sort;

import org.apache.inlong.manager.common.enums.MQType;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.UpdateGroupProcessForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.EventSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ZkDisabledEventSelector
implements EventSelector {
    private static final Logger log = LoggerFactory.getLogger(ZkDisabledEventSelector.class);

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        String groupId = processForm.getInlongGroupId();
        if (processForm instanceof GroupResourceProcessForm) {
            GroupResourceProcessForm groupResourceForm = (GroupResourceProcessForm)processForm;
            InlongGroupInfo groupInfo = groupResourceForm.getGroupInfo();
            boolean enable = groupInfo.getZookeeperEnabled() == 0 && MQType.forType((String)groupInfo.getMiddlewareType()) != MQType.NONE;
            log.info("zookeeper disabled was [{}] for groupId [{}]", (Object)enable, (Object)groupId);
            return enable;
        }
        if (processForm instanceof UpdateGroupProcessForm) {
            UpdateGroupProcessForm updateGroupProcessForm = (UpdateGroupProcessForm)processForm;
            InlongGroupInfo groupInfo = updateGroupProcessForm.getGroupInfo();
            boolean enable = groupInfo.getZookeeperEnabled() == 0 && MQType.forType((String)groupInfo.getMiddlewareType()) != MQType.NONE;
            log.info("zookeeper disabled was [{}] for groupId [{}]", (Object)enable, (Object)groupId);
            return enable;
        }
        log.info("zk disabled for groupId [{}]", (Object)groupId);
        return false;
    }
}

