/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.sort.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.FieldType;
import org.apache.inlong.manager.common.enums.MetaFieldType;
import org.apache.inlong.manager.common.pojo.sink.SinkFieldResponse;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamFieldInfo;
import org.apache.inlong.sort.formats.common.ArrayFormatInfo;
import org.apache.inlong.sort.formats.common.BooleanFormatInfo;
import org.apache.inlong.sort.formats.common.ByteFormatInfo;
import org.apache.inlong.sort.formats.common.ByteTypeInfo;
import org.apache.inlong.sort.formats.common.DateFormatInfo;
import org.apache.inlong.sort.formats.common.DecimalFormatInfo;
import org.apache.inlong.sort.formats.common.DoubleFormatInfo;
import org.apache.inlong.sort.formats.common.FloatFormatInfo;
import org.apache.inlong.sort.formats.common.FormatInfo;
import org.apache.inlong.sort.formats.common.IntFormatInfo;
import org.apache.inlong.sort.formats.common.LongFormatInfo;
import org.apache.inlong.sort.formats.common.ShortFormatInfo;
import org.apache.inlong.sort.formats.common.StringFormatInfo;
import org.apache.inlong.sort.formats.common.TimeFormatInfo;
import org.apache.inlong.sort.formats.common.TimestampFormatInfo;
import org.apache.inlong.sort.protocol.BuiltInFieldInfo;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.transformation.FieldMappingRule;

public class FieldInfoUtils {
    public static final Map<String, BuiltInFieldInfo.BuiltInField> BUILT_IN_FIELD_MAP = new HashMap<String, BuiltInFieldInfo.BuiltInField>();

    public static List<FieldMappingRule.FieldMappingUnit> createFieldInfo(List<InlongStreamFieldInfo> streamFieldList, List<SinkFieldResponse> fieldList, List<FieldInfo> sourceFields, List<FieldInfo> sinkFields) {
        for (InlongStreamFieldInfo field : streamFieldList) {
            FieldInfo sourceField = FieldInfoUtils.getFieldInfo(field.getFieldName(), field.getFieldType(), field.getIsMetaField() == 1, field.getFieldFormat());
            sourceFields.add(sourceField);
        }
        ArrayList<FieldMappingRule.FieldMappingUnit> mappingUnitList = new ArrayList<FieldMappingRule.FieldMappingUnit>();
        for (SinkFieldResponse field : fieldList) {
            FieldInfo sinkField = FieldInfoUtils.getFieldInfo(field.getFieldName(), field.getFieldType(), field.getIsMetaField() == 1, field.getFieldFormat());
            sinkFields.add(sinkField);
            if (!StringUtils.isNotBlank((CharSequence)field.getSourceFieldName())) continue;
            FieldInfo sourceField = FieldInfoUtils.getFieldInfo(field.getSourceFieldName(), field.getSourceFieldType(), field.getIsMetaField() == 1, field.getFieldFormat());
            mappingUnitList.add(new FieldMappingRule.FieldMappingUnit(sourceField, sinkField));
        }
        return mappingUnitList;
    }

    private static FieldInfo getFieldInfo(String fieldName, String fieldType, boolean isBuiltin, String format) {
        BuiltInFieldInfo.BuiltInField builtInField = BUILT_IN_FIELD_MAP.get(fieldName);
        FormatInfo formatInfo = FieldInfoUtils.convertFieldFormat(fieldType.toLowerCase(), format);
        Object fieldInfo = isBuiltin && builtInField != null ? new BuiltInFieldInfo(fieldName, formatInfo, builtInField) : new FieldInfo(fieldName, formatInfo);
        return fieldInfo;
    }

    public static List<FieldMappingRule.FieldMappingUnit> setAllMigrationFieldMapping(List<FieldInfo> sourceFields, List<FieldInfo> sinkFields) {
        ArrayList<FieldMappingRule.FieldMappingUnit> mappingUnitList = new ArrayList<FieldMappingRule.FieldMappingUnit>();
        BuiltInFieldInfo dataField = new BuiltInFieldInfo("data", (FormatInfo)StringFormatInfo.INSTANCE, BuiltInFieldInfo.BuiltInField.MYSQL_METADATA_DATA);
        sourceFields.add((FieldInfo)dataField);
        sinkFields.add((FieldInfo)dataField);
        mappingUnitList.add(new FieldMappingRule.FieldMappingUnit((FieldInfo)dataField, (FieldInfo)dataField));
        for (Map.Entry<String, BuiltInFieldInfo.BuiltInField> entry : BUILT_IN_FIELD_MAP.entrySet()) {
            if (entry.getKey().equals("data_time")) continue;
            BuiltInFieldInfo fieldInfo = new BuiltInFieldInfo(entry.getKey(), (FormatInfo)StringFormatInfo.INSTANCE, entry.getValue());
            sourceFields.add((FieldInfo)fieldInfo);
            sinkFields.add((FieldInfo)fieldInfo);
            mappingUnitList.add(new FieldMappingRule.FieldMappingUnit((FieldInfo)fieldInfo, (FieldInfo)fieldInfo));
        }
        return mappingUnitList;
    }

    public static FormatInfo convertFieldFormat(String type) {
        return FieldInfoUtils.convertFieldFormat(type, null);
    }

    public static FormatInfo convertFieldFormat(String type, String format) {
        BooleanFormatInfo formatInfo;
        FieldType fieldType = FieldType.forName((String)type);
        switch (fieldType) {
            case BOOLEAN: {
                formatInfo = new BooleanFormatInfo();
                break;
            }
            case TINYINT: 
            case BYTE: {
                formatInfo = new ByteFormatInfo();
                break;
            }
            case SMALLINT: 
            case SHORT: {
                formatInfo = new ShortFormatInfo();
                break;
            }
            case INT: {
                formatInfo = new IntFormatInfo();
                break;
            }
            case BIGINT: 
            case LONG: {
                formatInfo = new LongFormatInfo();
                break;
            }
            case FLOAT: {
                formatInfo = new FloatFormatInfo();
                break;
            }
            case DOUBLE: {
                formatInfo = new DoubleFormatInfo();
                break;
            }
            case DECIMAL: {
                formatInfo = new DecimalFormatInfo();
                break;
            }
            case DATE: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    formatInfo = new DateFormatInfo(FieldInfoUtils.convertToSortFormat(format));
                    break;
                }
                formatInfo = new DateFormatInfo();
                break;
            }
            case TIME: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    formatInfo = new TimeFormatInfo(FieldInfoUtils.convertToSortFormat(format));
                    break;
                }
                formatInfo = new TimeFormatInfo();
                break;
            }
            case TIMESTAMP: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    formatInfo = new TimestampFormatInfo(FieldInfoUtils.convertToSortFormat(format));
                    break;
                }
                formatInfo = new TimestampFormatInfo();
                break;
            }
            case BINARY: 
            case FIXED: {
                formatInfo = new ArrayFormatInfo(ByteTypeInfo::new);
                break;
            }
            default: {
                formatInfo = new StringFormatInfo();
            }
        }
        return formatInfo;
    }

    private static String convertToSortFormat(String format) {
        String sortFormat = format;
        switch (format) {
            case "MICROSECONDS": {
                sortFormat = "MICROS";
                break;
            }
            case "MILLISECONDS": {
                sortFormat = "MILLIS";
                break;
            }
            case "SECONDS": {
                sortFormat = "SECONDS";
                break;
            }
        }
        return sortFormat;
    }

    static {
        BUILT_IN_FIELD_MAP.put(MetaFieldType.DATA_TIME.getName(), BuiltInFieldInfo.BuiltInField.DATA_TIME);
        BUILT_IN_FIELD_MAP.put(MetaFieldType.DATABASE.getName(), BuiltInFieldInfo.BuiltInField.MYSQL_METADATA_DATABASE);
        BUILT_IN_FIELD_MAP.put(MetaFieldType.TABLE.getName(), BuiltInFieldInfo.BuiltInField.MYSQL_METADATA_TABLE);
        BUILT_IN_FIELD_MAP.put(MetaFieldType.EVENT_TIME.getName(), BuiltInFieldInfo.BuiltInField.MYSQL_METADATA_EVENT_TIME);
        BUILT_IN_FIELD_MAP.put(MetaFieldType.IS_DDL.getName(), BuiltInFieldInfo.BuiltInField.MYSQL_METADATA_IS_DDL);
        BUILT_IN_FIELD_MAP.put(MetaFieldType.EVENT_TYPE.getName(), BuiltInFieldInfo.BuiltInField.MYSQL_METADATA_EVENT_TYPE);
    }
}

