/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.sort.util;

import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.manager.common.enums.SinkType;
import org.apache.inlong.manager.common.enums.SourceType;
import org.apache.inlong.manager.common.pojo.sink.SinkResponse;
import org.apache.inlong.manager.common.pojo.sink.kafka.KafkaSinkResponse;
import org.apache.inlong.manager.common.pojo.source.SourceResponse;
import org.apache.inlong.manager.common.pojo.source.binlog.BinlogSourceResponse;
import org.apache.inlong.manager.common.pojo.source.kafka.KafkaSourceResponse;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.sort.protocol.deserialization.AvroDeserializationInfo;
import org.apache.inlong.sort.protocol.deserialization.CanalDeserializationInfo;
import org.apache.inlong.sort.protocol.deserialization.CsvDeserializationInfo;
import org.apache.inlong.sort.protocol.deserialization.DebeziumDeserializationInfo;
import org.apache.inlong.sort.protocol.deserialization.DeserializationInfo;
import org.apache.inlong.sort.protocol.deserialization.JsonDeserializationInfo;
import org.apache.inlong.sort.protocol.serialization.AvroSerializationInfo;
import org.apache.inlong.sort.protocol.serialization.CanalSerializationInfo;
import org.apache.inlong.sort.protocol.serialization.DebeziumSerializationInfo;
import org.apache.inlong.sort.protocol.serialization.JsonSerializationInfo;
import org.apache.inlong.sort.protocol.serialization.SerializationInfo;
import org.springframework.util.Assert;

public class SerializationUtils {
    public static DeserializationInfo createDeserialInfo(SourceResponse sourceResponse, InlongStreamInfo streamInfo) {
        SourceType sourceType = SourceType.forType((String)sourceResponse.getSourceType());
        switch (sourceType) {
            case BINLOG: {
                return SerializationUtils.deserializeForBinlog((BinlogSourceResponse)sourceResponse);
            }
            case KAFKA: {
                return SerializationUtils.deserializeForKafka((KafkaSourceResponse)sourceResponse, streamInfo);
            }
            case FILE: {
                return SerializationUtils.deserializeForFile(streamInfo);
            }
            case AUTO_PUSH: {
                return SerializationUtils.deserializeForAutoPush(streamInfo);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported sourceType: %s", sourceType));
    }

    public static SerializationInfo createSerialInfo(SourceResponse sourceResponse, SinkResponse sinkResponse) {
        SinkType sinkType = SinkType.forType((String)sinkResponse.getSinkType());
        switch (sinkType) {
            case HIVE: {
                return null;
            }
            case KAFKA: {
                return SerializationUtils.serializeForKafka(sourceResponse, (KafkaSinkResponse)sinkResponse);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported sinkType: %s", sinkType));
    }

    private static DeserializationInfo deserializeForBinlog(BinlogSourceResponse sourceResponse) {
        return new DebeziumDeserializationInfo(true, sourceResponse.getTimestampFormatStandard());
    }

    private static DeserializationInfo deserializeForKafka(KafkaSourceResponse source, InlongStreamInfo stream) {
        String serializationType = source.getSerializationType();
        DataTypeEnum dataType = DataTypeEnum.forName((String)serializationType);
        switch (dataType) {
            case CSV: {
                char separator = stream.getDataSeparator().toCharArray()[0];
                return new CsvDeserializationInfo(separator);
            }
            case AVRO: {
                return new AvroDeserializationInfo();
            }
            case JSON: {
                return new JsonDeserializationInfo();
            }
            case CANAL: {
                return new CanalDeserializationInfo(source.getDatabasePattern(), source.getTablePattern(), source.isIgnoreParseErrors(), source.getTimestampFormatStandard(), true);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported serializationType for Kafka source: %s", serializationType));
    }

    private static SerializationInfo serializeForKafka(SourceResponse sourceResponse, KafkaSinkResponse sinkResponse) {
        String serializationType = sinkResponse.getSerializationType();
        DataTypeEnum dataType = DataTypeEnum.forName((String)serializationType);
        switch (dataType) {
            case AVRO: {
                return new AvroSerializationInfo();
            }
            case JSON: {
                return new JsonSerializationInfo();
            }
            case CANAL: {
                return new CanalSerializationInfo();
            }
            case DEBEZIUM_JSON: {
                Assert.isInstanceOf(BinlogSourceResponse.class, (Object)sourceResponse, (String)"Unsupported serializationType for Kafka");
                BinlogSourceResponse binlogSource = (BinlogSourceResponse)sourceResponse;
                return new DebeziumSerializationInfo(binlogSource.getTimestampFormatStandard(), "FAIL", "", false);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported serializationType for Kafka sink: %s", serializationType));
    }

    private static DeserializationInfo deserializeForFile(InlongStreamInfo streamInfo) {
        String dataType = streamInfo.getDataType();
        DataTypeEnum typeEnum = DataTypeEnum.forName((String)dataType);
        switch (typeEnum) {
            case CSV: {
                char separator = streamInfo.getDataSeparator().toCharArray()[0];
                return new CsvDeserializationInfo(separator);
            }
            case AVRO: {
                return new AvroDeserializationInfo();
            }
            case JSON: {
                return new JsonDeserializationInfo();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported data type for File source: %s", dataType));
    }

    private static DeserializationInfo deserializeForAutoPush(InlongStreamInfo streamInfo) {
        String dataType = streamInfo.getDataType();
        DataTypeEnum typeEnum = DataTypeEnum.forName((String)dataType);
        switch (typeEnum) {
            case CSV: {
                char separator = streamInfo.getDataSeparator().toCharArray()[0];
                return new CsvDeserializationInfo(separator);
            }
            case AVRO: {
                return new AvroDeserializationInfo();
            }
            case JSON: {
                return new JsonDeserializationInfo();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported data type for DataProxy SDK source: %s", dataType));
    }
}

