/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.sort.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.FieldType;
import org.apache.inlong.manager.common.enums.FileFormat;
import org.apache.inlong.manager.common.enums.SinkType;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.sink.SinkFieldBase;
import org.apache.inlong.manager.common.pojo.sink.SinkResponse;
import org.apache.inlong.manager.common.pojo.sink.ck.ClickHouseSinkResponse;
import org.apache.inlong.manager.common.pojo.sink.hive.HivePartitionField;
import org.apache.inlong.manager.common.pojo.sink.hive.HiveSinkResponse;
import org.apache.inlong.manager.common.pojo.sink.iceberg.IcebergSinkResponse;
import org.apache.inlong.manager.common.pojo.sink.kafka.KafkaSinkResponse;
import org.apache.inlong.manager.common.pojo.source.SourceResponse;
import org.apache.inlong.manager.service.thirdparty.sort.util.SerializationUtils;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.serialization.SerializationInfo;
import org.apache.inlong.sort.protocol.sink.ClickHouseSinkInfo;
import org.apache.inlong.sort.protocol.sink.HiveSinkInfo;
import org.apache.inlong.sort.protocol.sink.IcebergSinkInfo;
import org.apache.inlong.sort.protocol.sink.KafkaSinkInfo;
import org.apache.inlong.sort.protocol.sink.SinkInfo;

public class SinkInfoUtils {
    private static final String DATA_FORMAT = "yyyyMMddHH";
    private static final String TIME_FORMAT = "HHmmss";
    private static final String DATA_TIME_FORMAT = "yyyyMMddHHmmss";

    public static SinkInfo createSinkInfo(SourceResponse sourceResponse, SinkResponse sinkResponse, List<FieldInfo> sinkFields) {
        HiveSinkInfo sinkInfo;
        String sinkType = sinkResponse.getSinkType();
        if (SinkType.forType((String)sinkType) == SinkType.HIVE) {
            sinkInfo = SinkInfoUtils.createHiveSinkInfo((HiveSinkResponse)sinkResponse, sinkFields);
        } else if (SinkType.forType((String)sinkType) == SinkType.KAFKA) {
            sinkInfo = SinkInfoUtils.createKafkaSinkInfo(sourceResponse, (KafkaSinkResponse)sinkResponse, sinkFields);
        } else if ("ICEBERG".equals(sinkType)) {
            sinkInfo = SinkInfoUtils.createIcebergSinkInfo((IcebergSinkResponse)sinkResponse, sinkFields);
        } else if (SinkType.forType((String)sinkType) == SinkType.CLICKHOUSE) {
            sinkInfo = SinkInfoUtils.createClickhouseSinkInfo((ClickHouseSinkResponse)sinkResponse, sinkFields);
        } else {
            throw new BusinessException(String.format("Unsupported SinkType {%s}", sinkType));
        }
        return sinkInfo;
    }

    private static ClickHouseSinkInfo createClickhouseSinkInfo(ClickHouseSinkResponse sinkResponse, List<FieldInfo> sinkFields) {
        boolean distributedTable;
        if (StringUtils.isEmpty((CharSequence)sinkResponse.getJdbcUrl())) {
            throw new BusinessException(String.format("ClickHouse={%s} server url cannot be empty", sinkResponse));
        }
        if (CollectionUtils.isEmpty((Collection)sinkResponse.getFieldList())) {
            throw new BusinessException(String.format("ClickHouse={%s} fields cannot be empty", sinkResponse));
        }
        if (StringUtils.isEmpty((CharSequence)sinkResponse.getTableName())) {
            throw new BusinessException(String.format("ClickHouse={%s} table name cannot be empty", sinkResponse));
        }
        if (StringUtils.isEmpty((CharSequence)sinkResponse.getDbName())) {
            throw new BusinessException(String.format("ClickHouse={%s} database name cannot be empty", sinkResponse));
        }
        Integer isDistributed = sinkResponse.getIsDistributed();
        if (isDistributed == null) {
            throw new BusinessException(String.format("ClickHouse={%s} isDistributed cannot be null", sinkResponse));
        }
        ClickHouseSinkInfo.PartitionStrategy partitionStrategy = ClickHouseSinkInfo.PartitionStrategy.RANDOM;
        boolean bl = distributedTable = isDistributed == 1;
        if (distributedTable) {
            if (ClickHouseSinkInfo.PartitionStrategy.BALANCE.name().equalsIgnoreCase(sinkResponse.getPartitionStrategy())) {
                partitionStrategy = ClickHouseSinkInfo.PartitionStrategy.BALANCE;
            } else if (ClickHouseSinkInfo.PartitionStrategy.HASH.name().equalsIgnoreCase(sinkResponse.getPartitionStrategy())) {
                partitionStrategy = ClickHouseSinkInfo.PartitionStrategy.HASH;
            }
        }
        return new ClickHouseSinkInfo(sinkResponse.getJdbcUrl(), sinkResponse.getDbName(), sinkResponse.getTableName(), sinkResponse.getUsername(), sinkResponse.getPassword(), distributedTable, partitionStrategy, sinkResponse.getPartitionFields(), sinkFields.toArray(new FieldInfo[0]), new String[0], sinkResponse.getFlushInterval().intValue(), sinkResponse.getFlushRecord().intValue(), sinkResponse.getRetryTimes().intValue());
    }

    private static IcebergSinkInfo createIcebergSinkInfo(IcebergSinkResponse sinkResponse, List<FieldInfo> sinkFields) {
        if (StringUtils.isEmpty((CharSequence)sinkResponse.getDataPath())) {
            throw new BusinessException(String.format("Iceberg={%s} data path cannot be empty", sinkResponse));
        }
        return new IcebergSinkInfo(sinkFields.toArray(new FieldInfo[0]), sinkResponse.getDataPath());
    }

    private static KafkaSinkInfo createKafkaSinkInfo(SourceResponse sourceResponse, KafkaSinkResponse sinkResponse, List<FieldInfo> sinkFields) {
        String addressUrl = sinkResponse.getBootstrapServers();
        String topicName = sinkResponse.getTopicName();
        SerializationInfo serializationInfo = SerializationUtils.createSerialInfo(sourceResponse, (SinkResponse)sinkResponse);
        return new KafkaSinkInfo(sinkFields.toArray(new FieldInfo[0]), addressUrl, topicName, serializationInfo);
    }

    private static HiveSinkInfo createHiveSinkInfo(HiveSinkResponse hiveInfo, List<FieldInfo> sinkFields) {
        if (hiveInfo.getJdbcUrl() == null) {
            throw new BusinessException(String.format("HiveSink={%s} server url cannot be empty", hiveInfo));
        }
        if (CollectionUtils.isEmpty((Collection)hiveInfo.getFieldList())) {
            throw new BusinessException(String.format("HiveSink={%s} fields cannot be empty", hiveInfo));
        }
        Character separator = Character.valueOf((char)Integer.parseInt(hiveInfo.getDataSeparator()));
        FileFormat format = FileFormat.forName((String)hiveInfo.getFileFormat());
        Object fileFormat = format == FileFormat.ORCFile ? new HiveSinkInfo.OrcFileFormat(1000) : (format == FileFormat.SequenceFile ? new HiveSinkInfo.SequenceFileFormat(separator, 100) : (format == FileFormat.Parquet ? new HiveSinkInfo.ParquetFileFormat() : new HiveSinkInfo.TextFileFormat(separator)));
        List<Object> partitionList = new ArrayList();
        List partitionFieldList = hiveInfo.getPartitionFieldList();
        if (CollectionUtils.isNotEmpty((Collection)partitionFieldList)) {
            SinkInfoUtils.checkPartitionField(hiveInfo.getFieldList(), partitionFieldList);
            partitionList = partitionFieldList.stream().map(s -> {
                HiveSinkInfo.HiveFieldPartitionInfo partition;
                String fieldFormat = s.getFieldFormat();
                switch (FieldType.forName((String)s.getFieldType())) {
                    case TIMESTAMP: {
                        fieldFormat = StringUtils.isNotBlank((CharSequence)fieldFormat) ? fieldFormat : DATA_TIME_FORMAT;
                        partition = new HiveSinkInfo.HiveTimePartitionInfo(s.getFieldName(), fieldFormat);
                        break;
                    }
                    case DATE: {
                        fieldFormat = StringUtils.isNotBlank((CharSequence)fieldFormat) ? fieldFormat : DATA_FORMAT;
                        partition = new HiveSinkInfo.HiveTimePartitionInfo(s.getFieldName(), fieldFormat);
                        break;
                    }
                    default: {
                        partition = new HiveSinkInfo.HiveFieldPartitionInfo(s.getFieldName());
                    }
                }
                return partition;
            }).collect(Collectors.toList());
        }
        StringBuilder dataPathBuilder = new StringBuilder();
        String dataPath = hiveInfo.getDataPath();
        if (!dataPath.endsWith("/")) {
            dataPathBuilder.append(dataPath).append("/");
        }
        dataPath = dataPathBuilder.append(hiveInfo.getTableName()).toString();
        return new HiveSinkInfo(sinkFields.toArray(new FieldInfo[0]), hiveInfo.getJdbcUrl(), hiveInfo.getDbName(), hiveInfo.getTableName(), hiveInfo.getUsername(), hiveInfo.getPassword(), dataPath, partitionList.toArray(new HiveSinkInfo.HivePartitionInfo[0]), (HiveSinkInfo.HiveFileFormat)fileFormat);
    }

    public static void checkPartitionField(List<? extends SinkFieldBase> fieldList, List<HivePartitionField> partitionList) {
        if (CollectionUtils.isEmpty(partitionList)) {
            return;
        }
        if (CollectionUtils.isEmpty(fieldList)) {
            throw new BusinessException(ErrorCodeEnum.SINK_FIELD_LIST_IS_EMPTY);
        }
        HashMap sinkFieldMap = new HashMap(fieldList.size());
        fieldList.forEach(field -> sinkFieldMap.put(field.getFieldName(), field));
        for (HivePartitionField partitionField : partitionList) {
            String fieldName = partitionField.getFieldName();
            if (StringUtils.isBlank((CharSequence)fieldName)) {
                throw new BusinessException(ErrorCodeEnum.PARTITION_FIELD_NAME_IS_EMPTY);
            }
            SinkFieldBase sinkField = (SinkFieldBase)sinkFieldMap.get(fieldName);
            if (sinkField == null) {
                throw new BusinessException(String.format(ErrorCodeEnum.PARTITION_FIELD_NOT_FOUND.getMessage(), fieldName));
            }
            if (!StringUtils.isBlank((CharSequence)sinkField.getSourceFieldName())) continue;
            throw new BusinessException(String.format(ErrorCodeEnum.PARTITION_FIELD_NO_SOURCE_FIELD.getMessage(), fieldName));
        }
    }
}

