/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdparty.sort.util;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.pojo.dataproxy.PulsarClusterInfo;
import org.apache.inlong.manager.common.beans.ClusterBean;
import org.apache.inlong.manager.common.enums.MQType;
import org.apache.inlong.manager.common.enums.SourceType;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.group.InlongGroupPulsarInfo;
import org.apache.inlong.manager.common.pojo.source.SourceResponse;
import org.apache.inlong.manager.common.pojo.source.binlog.BinlogSourceResponse;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.service.thirdparty.sort.util.SerializationUtils;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.deserialization.DeserializationInfo;
import org.apache.inlong.sort.protocol.source.PulsarSourceInfo;
import org.apache.inlong.sort.protocol.source.SourceInfo;
import org.apache.inlong.sort.protocol.source.TDMQPulsarSourceInfo;
import org.apache.inlong.sort.protocol.source.TubeSourceInfo;

public class SourceInfoUtils {
    public static boolean isBinlogAllMigration(SourceResponse sourceResponse) {
        if (sourceResponse == null) {
            return false;
        }
        if (SourceType.BINLOG.getType().equalsIgnoreCase(sourceResponse.getSourceType())) {
            BinlogSourceResponse binlogSource = (BinlogSourceResponse)sourceResponse;
            return binlogSource.isAllMigration();
        }
        return false;
    }

    public static SourceInfo createSourceInfo(PulsarClusterInfo pulsarCluster, String masterAddress, ClusterBean clusterBean, InlongGroupInfo groupInfo, InlongStreamInfo streamInfo, SourceResponse sourceResponse, List<FieldInfo> sourceFields) {
        SourceInfo sourceInfo;
        MQType mqType = MQType.forType((String)groupInfo.getMiddlewareType());
        DeserializationInfo deserializationInfo = SerializationUtils.createDeserialInfo(sourceResponse, streamInfo);
        if (mqType == MQType.PULSAR || mqType == MQType.TDMQ_PULSAR) {
            sourceInfo = SourceInfoUtils.createPulsarSourceInfo(pulsarCluster, clusterBean, groupInfo, streamInfo, deserializationInfo, sourceFields);
        } else if (mqType == MQType.TUBE) {
            sourceInfo = SourceInfoUtils.createTubeSourceInfo(groupInfo, masterAddress, clusterBean, deserializationInfo, sourceFields);
        } else {
            throw new WorkflowListenerException(String.format("Unsupported middleware {%s}", mqType));
        }
        return sourceInfo;
    }

    private static SourceInfo createPulsarSourceInfo(PulsarClusterInfo pulsarCluster, ClusterBean clusterBean, InlongGroupInfo groupInfo, InlongStreamInfo streamInfo, DeserializationInfo deserializationInfo, List<FieldInfo> fieldInfos) {
        String topicName = streamInfo.getMqResourceObj();
        InlongGroupPulsarInfo pulsarInfo = (InlongGroupPulsarInfo)groupInfo.getMqExtInfo();
        String tenant = clusterBean.getDefaultTenant();
        if (StringUtils.isNotEmpty((CharSequence)pulsarInfo.getTenant())) {
            tenant = pulsarInfo.getTenant();
        }
        String namespace = groupInfo.getMqResourceObj();
        String fullTopicName = "persistent://" + tenant + "/" + namespace + "/" + topicName;
        String consumerGroup = clusterBean.getAppName() + "_" + topicName + "_consumer_group";
        FieldInfo[] fieldInfosArr = fieldInfos.toArray(new FieldInfo[0]);
        String type = pulsarCluster.getType();
        if (StringUtils.isNotEmpty((CharSequence)type) && MQType.forType((String)type) == MQType.TDMQ_PULSAR) {
            return new TDMQPulsarSourceInfo(pulsarCluster.getBrokerServiceUrl(), fullTopicName, consumerGroup, pulsarCluster.getToken(), deserializationInfo, fieldInfosArr);
        }
        return new PulsarSourceInfo(pulsarCluster.getAdminUrl(), pulsarCluster.getBrokerServiceUrl(), fullTopicName, consumerGroup, deserializationInfo, fieldInfosArr, pulsarCluster.getToken());
    }

    private static TubeSourceInfo createTubeSourceInfo(InlongGroupInfo groupInfo, String masterAddress, ClusterBean clusterBean, DeserializationInfo deserializationInfo, List<FieldInfo> fieldInfos) {
        Preconditions.checkNotNull((Object)masterAddress, (String)"tube cluster address cannot be empty");
        String topic = groupInfo.getMqResourceObj();
        String consumerGroup = clusterBean.getAppName() + "_" + topic + "_consumer_group";
        return new TubeSourceInfo(topic, masterAddress, consumerGroup, deserializationInfo, fieldInfos.toArray(new FieldInfo[0]));
    }
}

