/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.utils;

import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class SpringContextUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SpringContextUtils.class);
    private static Properties props = new Properties();
    private static ConfigurableApplicationContext applicationContext;

    public static ConfigurableApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static void setApplicationContext(ConfigurableApplicationContext applicationContext) {
        SpringContextUtils.applicationContext = applicationContext;
        try {
            ClassPathResource resource = new ClassPathResource("/bean.properties");
            props = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public static Object getBean(String beanName, String defaultClass) {
        Object obj = null;
        try {
            obj = applicationContext.getBean(beanName);
            if (obj != null) {
                return obj;
            }
        }
        catch (Exception e) {
            LOG.error("Can not getBean:{},error:{}", (Object)beanName, (Object)e.getMessage());
        }
        String beanClassName = props.getProperty(beanName, defaultClass);
        try {
            SpringContextUtils.registerBean(beanName, beanClassName);
            obj = applicationContext.getBean(beanName);
            if (obj != null) {
                return obj;
            }
        }
        catch (Exception e) {
            LOG.error("Can not registerBean:{},beanClassName:{},defaultClass:{},error:{}", new Object[]{beanName, beanClassName, defaultClass, e});
        }
        return null;
    }

    public static Object getBean(Class<?> requiredType) {
        return applicationContext.getBean(requiredType);
    }

    private static void registerBean(String beanName, String beanClassName) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)applicationContext.getBeanFactory();
        BeanDefinitionBuilder beanBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)beanClassName);
        beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanBuilder.getRawBeanDefinition());
    }
}

