/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.MapUtils;
import org.apache.inlong.manager.service.source.listener.SourceDeleteEventSelector;
import org.apache.inlong.manager.service.source.listener.SourceDeleteListener;
import org.apache.inlong.manager.service.source.listener.SourceRestartEventSelector;
import org.apache.inlong.manager.service.source.listener.SourceRestartListener;
import org.apache.inlong.manager.service.source.listener.SourceStopEventSelector;
import org.apache.inlong.manager.service.source.listener.SourceStopListener;
import org.apache.inlong.manager.service.thirdparty.hive.CreateHiveSinkListener;
import org.apache.inlong.manager.service.thirdparty.hive.HiveSinkEventSelector;
import org.apache.inlong.manager.service.thirdparty.mq.CreatePulsarGroupTaskListener;
import org.apache.inlong.manager.service.thirdparty.mq.CreatePulsarResourceTaskListener;
import org.apache.inlong.manager.service.thirdparty.mq.CreateTubeGroupTaskListener;
import org.apache.inlong.manager.service.thirdparty.mq.CreateTubeTopicTaskListener;
import org.apache.inlong.manager.service.thirdparty.mq.PulsarEventSelector;
import org.apache.inlong.manager.service.thirdparty.mq.TubeEventSelector;
import org.apache.inlong.manager.service.thirdparty.sort.CreateSortConfigListener;
import org.apache.inlong.manager.service.thirdparty.sort.PushSortConfigListener;
import org.apache.inlong.manager.service.thirdparty.sort.ZkDisabledEventSelector;
import org.apache.inlong.manager.service.thirdparty.sort.ZkEnabledEventSelector;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.ServiceTaskListenerProvider;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.event.EventSelector;
import org.apache.inlong.manager.workflow.event.task.DataSourceOperateListener;
import org.apache.inlong.manager.workflow.event.task.QueueOperateListener;
import org.apache.inlong.manager.workflow.event.task.SinkOperateListener;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.plugin.Plugin;
import org.apache.inlong.manager.workflow.plugin.PluginBinder;
import org.apache.inlong.manager.workflow.plugin.ProcessPlugin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceTaskListenerFactory
implements PluginBinder,
ServiceTaskListenerProvider {
    private Map<DataSourceOperateListener, EventSelector> sourceOperateListeners;
    private Map<SinkOperateListener, EventSelector> sinkOperateListeners;
    private Map<QueueOperateListener, EventSelector> queueOperateListeners;
    private Map<SortOperateListener, EventSelector> sortOperateListeners;
    @Autowired
    private SourceStopListener sourceStopListener;
    @Autowired
    private SourceRestartListener sourceRestartListener;
    @Autowired
    private SourceDeleteListener sourceDeleteListener;
    @Autowired
    private CreateTubeTopicTaskListener createTubeTopicTaskListener;
    @Autowired
    private CreateTubeGroupTaskListener createTubeGroupTaskListener;
    @Autowired
    private CreatePulsarResourceTaskListener createPulsarResourceTaskListener;
    @Autowired
    private CreatePulsarGroupTaskListener createPulsarGroupTaskListener;
    @Autowired
    private CreateHiveSinkListener createHiveSinkListener;
    @Autowired
    private HiveSinkEventSelector hiveSinkEventSelector;
    @Autowired
    private PushSortConfigListener pushSortConfigListener;
    @Autowired
    private ZkEnabledEventSelector zkEnabledEventSelector;
    @Autowired
    private ZkDisabledEventSelector zkDisabledEventSelector;
    @Autowired
    private CreateSortConfigListener createSortConfigListener;

    @PostConstruct
    public void init() {
        this.sourceOperateListeners = new LinkedHashMap<DataSourceOperateListener, EventSelector>();
        this.sourceOperateListeners.put(this.sourceStopListener, new SourceStopEventSelector());
        this.sourceOperateListeners.put(this.sourceDeleteListener, new SourceDeleteEventSelector());
        this.sourceOperateListeners.put(this.sourceRestartListener, new SourceRestartEventSelector());
        this.sinkOperateListeners = new LinkedHashMap<SinkOperateListener, EventSelector>();
        this.sinkOperateListeners.put(this.createHiveSinkListener, this.hiveSinkEventSelector);
        this.queueOperateListeners = new LinkedHashMap<QueueOperateListener, EventSelector>();
        this.queueOperateListeners.put(this.createTubeTopicTaskListener, new TubeEventSelector());
        this.queueOperateListeners.put(this.createTubeGroupTaskListener, new TubeEventSelector());
        this.queueOperateListeners.put(this.createPulsarResourceTaskListener, new PulsarEventSelector());
        this.queueOperateListeners.put(this.createPulsarGroupTaskListener, new PulsarEventSelector());
        this.sortOperateListeners = new LinkedHashMap<SortOperateListener, EventSelector>();
        this.sortOperateListeners.put(this.pushSortConfigListener, this.zkEnabledEventSelector);
        this.sortOperateListeners.put(this.createSortConfigListener, this.zkDisabledEventSelector);
    }

    public void clearListeners() {
        this.sourceOperateListeners = new LinkedHashMap<DataSourceOperateListener, EventSelector>();
        this.sinkOperateListeners = new LinkedHashMap<SinkOperateListener, EventSelector>();
        this.queueOperateListeners = new LinkedHashMap<QueueOperateListener, EventSelector>();
        this.sortOperateListeners = new LinkedHashMap<SortOperateListener, EventSelector>();
    }

    public List<TaskEventListener> get(WorkflowContext workflowContext, ServiceTaskType serviceTaskType) {
        switch (serviceTaskType) {
            case INIT_MQ: {
                List<QueueOperateListener> queueOperateListeners = this.getQueueOperateListener(workflowContext);
                return Lists.newArrayList(queueOperateListeners);
            }
            case INIT_SORT: 
            case STOP_SORT: 
            case RESTART_SORT: 
            case DELETE_SORT: {
                List<SortOperateListener> sortOperateListeners = this.getSortOperateListener(workflowContext);
                return Lists.newArrayList(sortOperateListeners);
            }
            case INIT_SOURCE: 
            case STOP_SOURCE: 
            case RESTART_SOURCE: 
            case DELETE_SOURCE: {
                List<DataSourceOperateListener> sourceOperateListeners = this.getSourceOperateListener(workflowContext);
                return Lists.newArrayList(sourceOperateListeners);
            }
            case INIT_SINK: {
                List<SinkOperateListener> sinkOperateListeners = this.getSinkOperateListener(workflowContext);
                return Lists.newArrayList(sinkOperateListeners);
            }
        }
        throw new IllegalArgumentException(String.format("UnSupport ServiceTaskType %s", serviceTaskType));
    }

    public List<DataSourceOperateListener> getSourceOperateListener(WorkflowContext context) {
        ArrayList<DataSourceOperateListener> listeners = new ArrayList<DataSourceOperateListener>();
        for (Map.Entry<DataSourceOperateListener, EventSelector> entry : this.sourceOperateListeners.entrySet()) {
            EventSelector selector = entry.getValue();
            if (selector == null || !selector.accept(context)) continue;
            listeners.add(entry.getKey());
        }
        return listeners;
    }

    public List<SinkOperateListener> getSinkOperateListener(WorkflowContext context) {
        ArrayList<SinkOperateListener> listeners = new ArrayList<SinkOperateListener>();
        for (Map.Entry<SinkOperateListener, EventSelector> entry : this.sinkOperateListeners.entrySet()) {
            EventSelector selector = entry.getValue();
            if (selector == null || !selector.accept(context)) continue;
            listeners.add(entry.getKey());
        }
        return listeners;
    }

    public List<QueueOperateListener> getQueueOperateListener(WorkflowContext context) {
        ArrayList<QueueOperateListener> listeners = new ArrayList<QueueOperateListener>();
        for (Map.Entry<QueueOperateListener, EventSelector> entry : this.queueOperateListeners.entrySet()) {
            EventSelector selector = entry.getValue();
            if (selector == null || !selector.accept(context)) continue;
            listeners.add(entry.getKey());
        }
        return listeners;
    }

    public List<SortOperateListener> getSortOperateListener(WorkflowContext context) {
        ArrayList<SortOperateListener> listeners = new ArrayList<SortOperateListener>();
        for (Map.Entry<SortOperateListener, EventSelector> entry : this.sortOperateListeners.entrySet()) {
            EventSelector selector = entry.getValue();
            if (selector == null || !selector.accept(context)) continue;
            listeners.add(entry.getKey());
        }
        return listeners;
    }

    public void acceptPlugin(Plugin plugin) {
        Map pluginSortOperateListeners;
        Map pluginQueueOperateListeners;
        Map pluginSinkOperateListeners;
        if (!(plugin instanceof ProcessPlugin)) {
            return;
        }
        ProcessPlugin processPlugin = (ProcessPlugin)plugin;
        Map pluginDsOperateListeners = processPlugin.createSourceOperateListeners();
        if (MapUtils.isNotEmpty((Map)pluginDsOperateListeners)) {
            this.sourceOperateListeners.putAll(processPlugin.createSourceOperateListeners());
        }
        if (MapUtils.isNotEmpty((Map)(pluginSinkOperateListeners = processPlugin.createSinkOperateListeners()))) {
            this.sinkOperateListeners.putAll(pluginSinkOperateListeners);
        }
        if (MapUtils.isNotEmpty((Map)(pluginQueueOperateListeners = processPlugin.createQueueOperateListeners()))) {
            this.queueOperateListeners.putAll(pluginQueueOperateListeners);
        }
        if (MapUtils.isNotEmpty((Map)(pluginSortOperateListeners = processPlugin.createSortOperateListeners()))) {
            this.sortOperateListeners.putAll(pluginSortOperateListeners);
        }
    }

    public void setSourceStopListener(SourceStopListener sourceStopListener) {
        this.sourceStopListener = sourceStopListener;
    }

    public void setSourceRestartListener(SourceRestartListener sourceRestartListener) {
        this.sourceRestartListener = sourceRestartListener;
    }

    public void setSourceDeleteListener(SourceDeleteListener sourceDeleteListener) {
        this.sourceDeleteListener = sourceDeleteListener;
    }

    public void setCreateTubeTopicTaskListener(CreateTubeTopicTaskListener createTubeTopicTaskListener) {
        this.createTubeTopicTaskListener = createTubeTopicTaskListener;
    }

    public void setCreateTubeGroupTaskListener(CreateTubeGroupTaskListener createTubeGroupTaskListener) {
        this.createTubeGroupTaskListener = createTubeGroupTaskListener;
    }

    public void setCreatePulsarResourceTaskListener(CreatePulsarResourceTaskListener createPulsarResourceTaskListener) {
        this.createPulsarResourceTaskListener = createPulsarResourceTaskListener;
    }

    public void setCreatePulsarGroupTaskListener(CreatePulsarGroupTaskListener createPulsarGroupTaskListener) {
        this.createPulsarGroupTaskListener = createPulsarGroupTaskListener;
    }

    public void setCreateHiveSinkListener(CreateHiveSinkListener createHiveSinkListener) {
        this.createHiveSinkListener = createHiveSinkListener;
    }

    public void setPushSortConfigListener(PushSortConfigListener pushSortConfigListener) {
        this.pushSortConfigListener = pushSortConfigListener;
    }
}

