/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow;

import org.apache.inlong.manager.dao.mapper.WorkflowEventLogEntityMapper;
import org.apache.inlong.manager.dao.mapper.WorkflowProcessEntityMapper;
import org.apache.inlong.manager.dao.mapper.WorkflowTaskEntityMapper;
import org.apache.inlong.manager.workflow.WorkflowConfig;
import org.apache.inlong.manager.workflow.core.EventListenerService;
import org.apache.inlong.manager.workflow.core.ProcessDefinitionRepository;
import org.apache.inlong.manager.workflow.core.ProcessDefinitionService;
import org.apache.inlong.manager.workflow.core.WorkflowEngine;
import org.apache.inlong.manager.workflow.core.WorkflowQueryService;
import org.apache.inlong.manager.workflow.core.impl.MemoryProcessDefinitionRepository;
import org.apache.inlong.manager.workflow.core.impl.WorkflowEngineImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;

@Component
@Configuration
public class WorkflowEngineConfig {
    @Autowired
    private WorkflowQueryService queryService;
    @Autowired
    private MemoryProcessDefinitionRepository memoryProcessRepository;
    @Autowired
    private WorkflowProcessEntityMapper processEntityMapper;
    @Autowired
    private WorkflowTaskEntityMapper taskEntityMapper;
    @Autowired
    private WorkflowEventLogEntityMapper eventLogMapper;
    @Autowired
    private PlatformTransactionManager platformTransactionManager;

    @Bean
    public WorkflowEngine workflowEngineer() {
        WorkflowConfig workflowConfig = new WorkflowConfig().setQueryService(this.queryService).setProcessEntityMapper(this.processEntityMapper).setTaskEntityMapper(this.taskEntityMapper).setEventLogMapper(this.eventLogMapper).setDefinitionRepository((ProcessDefinitionRepository)this.memoryProcessRepository).setTransactionManager(this.platformTransactionManager);
        return new WorkflowEngineImpl(workflowConfig);
    }

    @Bean
    public EventListenerService eventListenerService(WorkflowEngine workflowEngine) {
        return workflowEngine.eventListenerService();
    }

    @Bean
    public ProcessDefinitionService processDefinitionService(WorkflowEngine workflowEngine) {
        return workflowEngine.processDefinitionService();
    }
}

