/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group;

import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.ServiceTaskListenerFactory;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.group.listener.GroupCompleteProcessListener;
import org.apache.inlong.manager.service.workflow.group.listener.GroupFailedProcessListener;
import org.apache.inlong.manager.service.workflow.group.listener.InitGroupListener;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.ServiceTask;
import org.apache.inlong.manager.workflow.definition.ServiceTaskListenerProvider;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateGroupWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(CreateGroupWorkflowDefinition.class);
    @Autowired
    private InitGroupListener initGroupListener;
    @Autowired
    private GroupCompleteProcessListener groupCompleteProcessListener;
    @Autowired
    private GroupFailedProcessListener groupFailedProcessListener;
    @Autowired
    private ServiceTaskListenerFactory serviceTaskListenerFactory;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.addListener((ProcessEventListener)this.initGroupListener);
        process.addListener((ProcessEventListener)this.groupCompleteProcessListener);
        process.addListener((ProcessEventListener)this.groupFailedProcessListener);
        process.setType("Group Resource Creation");
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(GroupResourceProcessForm.class);
        process.setVersion(1);
        process.setHidden(Integer.valueOf(1));
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        ServiceTask initDataSourceTask = new ServiceTask();
        initDataSourceTask.setName("initSource");
        initDataSourceTask.setDisplayName("Group-InitSource");
        initDataSourceTask.addServiceTaskType(ServiceTaskType.INIT_SOURCE);
        initDataSourceTask.addListenerProvider((ServiceTaskListenerProvider)this.serviceTaskListenerFactory);
        process.addTask((WorkflowTask)initDataSourceTask);
        ServiceTask initMQResourceTask = new ServiceTask();
        initMQResourceTask.setName("initMQ");
        initMQResourceTask.setDisplayName("Group-InitMQ");
        initMQResourceTask.addServiceTaskType(ServiceTaskType.INIT_MQ);
        initMQResourceTask.addListenerProvider((ServiceTaskListenerProvider)this.serviceTaskListenerFactory);
        process.addTask((WorkflowTask)initMQResourceTask);
        ServiceTask initSortResourceTask = new ServiceTask();
        initSortResourceTask.setName("initSort");
        initSortResourceTask.setDisplayName("Group-InitSort");
        initSortResourceTask.addServiceTaskType(ServiceTaskType.INIT_SORT);
        initSortResourceTask.addListenerProvider((ServiceTaskListenerProvider)this.serviceTaskListenerFactory);
        process.addTask((WorkflowTask)initSortResourceTask);
        ServiceTask initSinkTask = new ServiceTask();
        initSinkTask.setName("initSink");
        initSinkTask.setDisplayName("Group-InitSink");
        initSinkTask.addServiceTaskType(ServiceTaskType.INIT_SINK);
        initSinkTask.addListenerProvider((ServiceTaskListenerProvider)this.serviceTaskListenerFactory);
        process.addTask((WorkflowTask)initSinkTask);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        startEvent.addNext((Element)initDataSourceTask);
        initDataSourceTask.addNext((Element)initMQResourceTask);
        initMQResourceTask.addNext((Element)initSortResourceTask);
        initSortResourceTask.addNext((Element)initSinkTask);
        initSinkTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.CREATE_GROUP_RESOURCE;
    }
}

