/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group;

import java.util.List;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowApproverFilterContext;
import org.apache.inlong.manager.common.pojo.workflow.form.InlongGroupApproveForm;
import org.apache.inlong.manager.common.pojo.workflow.form.NewGroupProcessForm;
import org.apache.inlong.manager.service.core.WorkflowApproverService;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.group.listener.GroupCancelProcessListener;
import org.apache.inlong.manager.service.workflow.group.listener.GroupPassTaskListener;
import org.apache.inlong.manager.service.workflow.group.listener.GroupRejectProcessListener;
import org.apache.inlong.manager.service.workflow.group.listener.StartCreateGroupProcessListener;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.UserTask;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewGroupWorkflowDefinition
implements WorkflowDefinition {
    @Autowired
    private GroupPassTaskListener groupPassTaskListener;
    @Autowired
    private GroupCancelProcessListener groupCancelProcessListener;
    @Autowired
    private GroupRejectProcessListener approveRejectProcessListener;
    @Autowired
    private StartCreateGroupProcessListener startCreateGroupProcessListener;
    @Autowired
    private WorkflowApproverService workflowApproverService;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.setType(this.getProcessName().getDisplayName());
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(NewGroupProcessForm.class);
        process.setVersion(1);
        process.addListener((ProcessEventListener)this.groupCancelProcessListener);
        process.addListener((ProcessEventListener)this.approveRejectProcessListener);
        process.addListener((ProcessEventListener)this.startCreateGroupProcessListener);
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        UserTask adminUserTask = new UserTask();
        adminUserTask.setName("ut_admin");
        adminUserTask.setDisplayName("System Administrator");
        adminUserTask.setFormClass(InlongGroupApproveForm.class);
        adminUserTask.setApproverAssign(context -> this.getTaskApprovers(adminUserTask.getName()));
        adminUserTask.addListener((TaskEventListener)this.groupPassTaskListener);
        process.addTask((WorkflowTask)adminUserTask);
        startEvent.addNext((Element)adminUserTask);
        adminUserTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.NEW_GROUP_PROCESS;
    }

    private List<String> getTaskApprovers(String taskName) {
        String processName = this.getProcessName().name();
        WorkflowApproverFilterContext context = new WorkflowApproverFilterContext();
        return this.workflowApproverService.getApprovers(processName, taskName, context);
    }
}

