/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group.listener;

import java.util.Objects;
import org.apache.inlong.manager.common.enums.GroupState;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.workflow.form.NewGroupProcessForm;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupCancelProcessListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(GroupCancelProcessListener.class);
    @Autowired
    private InlongGroupEntityMapper groupMapper;

    public ProcessEvent event() {
        return ProcessEvent.CANCEL;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        NewGroupProcessForm form = (NewGroupProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        InlongGroupEntity entity = this.groupMapper.selectByGroupId(groupId);
        if (entity == null) {
            throw new WorkflowListenerException("inlong group not found with group id=" + groupId);
        }
        if (!Objects.equals(GroupState.TO_BE_APPROVAL.getCode(), entity.getStatus())) {
            throw new WorkflowListenerException("current status was not allowed to cancel business");
        }
        String username = context.getApplicant();
        this.groupMapper.updateStatus(groupId, GroupState.TO_BE_SUBMIT.getCode(), username);
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

