/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group.listener;

import java.util.List;
import java.util.Objects;
import org.apache.inlong.manager.common.enums.GroupState;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupApproveRequest;
import org.apache.inlong.manager.common.pojo.workflow.form.InlongGroupApproveForm;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.service.core.InlongGroupService;
import org.apache.inlong.manager.service.core.InlongStreamService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupPassTaskListener
implements TaskEventListener {
    private static final Logger log = LoggerFactory.getLogger(GroupPassTaskListener.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private InlongStreamService streamService;

    public TaskEvent event() {
        return TaskEvent.APPROVE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        InlongGroupApproveForm form = (InlongGroupApproveForm)context.getActionContext().getForm();
        InlongGroupApproveRequest approveInfo = form.getGroupApproveInfo();
        String groupId = approveInfo.getInlongGroupId();
        InlongGroupEntity entity = this.groupMapper.selectByGroupId(groupId);
        if (entity == null) {
            throw new WorkflowListenerException("inlong group not found with group id=" + groupId);
        }
        if (!Objects.equals(GroupState.TO_BE_APPROVAL.getCode(), entity.getStatus())) {
            throw new WorkflowListenerException("inlong group status is [wait_approval], not allowed to approve again");
        }
        this.groupService.updateAfterApprove(approveInfo, context.getApplicant());
        List streamApproveInfoList = form.getStreamApproveInfoList();
        this.streamService.updateAfterApprove(streamApproveInfoList, context.getApplicant());
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

