/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group.listener;

import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupState;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.service.core.InlongGroupService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitGroupListener
implements ProcessEventListener {
    @Autowired
    private InlongGroupService groupService;

    public ProcessEvent event() {
        return ProcessEvent.CREATE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        InlongGroupInfo groupInfo = this.groupService.get(context.getProcessForm().getInlongGroupId());
        if (groupInfo == null) {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        int status = GroupState.CONFIG_ING.getCode();
        String username = context.getApplicant();
        this.groupService.updateStatus(groupInfo.getInlongGroupId(), status, username);
        form.setGroupInfo(groupInfo);
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

