/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group.listener;

import java.util.List;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.NewGroupProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.apache.inlong.manager.service.core.InlongGroupService;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StartCreateGroupProcessListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(StartCreateGroupProcessListener.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private InlongStreamEntityMapper streamMapper;

    public ProcessEvent event() {
        return ProcessEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        NewGroupProcessForm form = (NewGroupProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        GroupResourceProcessForm processForm = new GroupResourceProcessForm();
        processForm.setGroupInfo(this.groupService.get(groupId));
        String username = context.getApplicant();
        List inlongStreamEntityList = this.streamMapper.selectByGroupId(groupId);
        List streamList = CommonBeanUtils.copyListProperties((List)inlongStreamEntityList, InlongStreamInfo::new);
        processForm.setInlongStreamInfoList(streamList);
        this.workflowService.start(ProcessName.CREATE_GROUP_RESOURCE, username, (ProcessForm)processForm);
        return ListenerResult.success();
    }

    public boolean async() {
        return true;
    }
}

