/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group.listener;

import org.apache.inlong.manager.common.enums.GroupState;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.UpdateGroupProcessForm;
import org.apache.inlong.manager.service.core.InlongGroupService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateGroupFailedListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(UpdateGroupFailedListener.class);
    @Autowired
    private InlongGroupService groupService;

    public ProcessEvent event() {
        return ProcessEvent.FAIL;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        UpdateGroupProcessForm form = (UpdateGroupProcessForm)context.getProcessForm();
        String username = context.getApplicant();
        InlongGroupInfo groupInfo = form.getGroupInfo();
        this.groupService.updateStatus(groupInfo.getInlongGroupId(), GroupState.CONFIG_FAILED.getCode(), username);
        this.groupService.update(groupInfo.genRequest(), username);
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

